/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.branch;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.branch.AbstractBranching;
import choco.kernel.solver.branch.IntBranching;
import java.util.logging.Level;

public abstract class AbstractIntBranching
extends AbstractBranching
implements IntBranching {
    @Override
    public void goDownBranch(Object x, int i) throws ContradictionException {
        this.logDownBranch(x, i);
    }

    @Override
    public void goUpBranch(Object x, int i) throws ContradictionException {
        this.logUpBranch(x, i);
    }

    protected void logDownBranch(Object x, int i) {
        int n;
        if (logger.isLoggable(Level.FINE) && (n = this.manager.solver.getEnvironment().getWorldIndex()) <= this.manager.getLoggingMaxDepth()) {
            logger.log(Level.FINE, LOG_DOWN_MSG, new Object[]{n, x, this.getDecisionLogMsg(i), i});
        }
    }

    protected void logUpBranch(Object x, int i) {
        int n;
        if (logger.isLoggable(Level.FINE) && (n = this.manager.solver.getEnvironment().getWorldIndex()) <= this.manager.getLoggingMaxDepth()) {
            logger.log(Level.FINE, LOG_UP_MSG, new Object[]{n + 1, x, this.getDecisionLogMsg(i), i});
        }
    }
}

