/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver;

import choco.kernel.solver.Solver;
import choco.kernel.solver.StoredLimit;
import choco.kernel.solver.search.AbstractGlobalSearchLimit;
import choco.kernel.solver.variables.real.RealInterval;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class Solution {
    protected static final Logger logger = Logger.getLogger("choco");
    protected final Solver solver;
    protected final int[] intVarValues;
    protected final RealInterval[] realVarValues;
    protected final int[][] setVarValues;
    protected int objectiveValue;
    protected final Map<AbstractGlobalSearchLimit, AbstractGlobalSearchLimit> limits;

    public Solution(Solver solver) {
        this.solver = solver;
        int nbv = solver.getNbIntVars();
        this.intVarValues = new int[nbv];
        this.setVarValues = new int[solver.getNbSetVars()][];
        this.realVarValues = new RealInterval[solver.getNbRealVars()];
        for (int i = 0; i < nbv; ++i) {
            this.intVarValues[i] = Integer.MAX_VALUE;
        }
        this.objectiveValue = Integer.MAX_VALUE;
        ArrayList<AbstractGlobalSearchLimit> tmp = solver.getSearchStrategy().limits;
        this.limits = new HashMap<AbstractGlobalSearchLimit, AbstractGlobalSearchLimit>(tmp.size());
        for (AbstractGlobalSearchLimit l : tmp) {
            this.limits.put(l, new StoredLimit(l));
        }
    }

    public final int getObjectiveValue() {
        return this.objectiveValue;
    }

    public void recordIntValue(int intVarIndex, int intVarValue) {
        this.intVarValues[intVarIndex] = intVarValue;
    }

    public void recordSetValue(int setVarIndex, int[] setVarValue) {
        this.setVarValues[setVarIndex] = setVarValue;
    }

    public void recordRealValue(int realVarIndex, RealInterval realVarValue) {
        this.realVarValues[realVarIndex] = realVarValue;
    }

    public void recordIntObjective(int intObjectiveValue) {
        this.objectiveValue = intObjectiveValue;
    }

    public void recordLimit(AbstractGlobalSearchLimit limit) {
        StoredLimit tmp = (StoredLimit)this.limits.get(limit);
        tmp.synchronize(limit);
    }

    public int getIntValue(int varIndex) {
        return this.intVarValues[varIndex];
    }

    public int[] getSetValue(int varIndex) {
        return this.setVarValues[varIndex];
    }

    public RealInterval getRealValue(int varIndex) {
        return this.realVarValues[varIndex];
    }

    public Collection<AbstractGlobalSearchLimit> getLimits() {
        return this.limits.values();
    }
}

