/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver;

import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.PropagationEngine;
import choco.kernel.solver.variables.Domain;
import choco.kernel.solver.variables.Var;

public class ContradictionException
extends Exception {
    private static final long serialVersionUID = 1542770449283056616L;
    public static final int UNKNOWN = -1;
    public static final int VARIABLE = 1;
    public static final int CONSTRAINT = 2;
    public static final int DOMAIN = 3;
    public static final int SEARCH_LIMIT = 4;
    private Object contradictionCause;
    private int contradictionType;

    public ContradictionException(Object cause, int type) {
        this.set(cause, type);
    }

    public void set(Object cause, int type) {
        PropagationEngine pe = null;
        this.contradictionCause = cause;
        this.contradictionType = type;
        switch (type) {
            case 1: {
                pe = ((Var)cause).getSolver().getPropagationEngine();
                pe.setContradictionCause(cause, 1);
                break;
            }
            case 2: {
                pe = ((SConstraint)cause).getSolver().getPropagationEngine();
                pe.setContradictionCause(cause, 2);
                break;
            }
            case 3: {
                pe = ((Domain)cause).getSolver().getPropagationEngine();
                pe.setContradictionCause(cause, 3);
                break;
            }
            case 4: {
                break;
            }
        }
    }

    @Override
    public String toString() {
        return "Exception due to " + this.contradictionCause;
    }

    public Object getContradictionCause() {
        return this.contradictionCause;
    }

    public int getContraditionType() {
        return this.contradictionType;
    }
}

