/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables.tree;

import choco.kernel.model.variables.MultipleVariables;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.tree.TreeNodeObject;
import java.util.BitSet;
import java.util.List;

public class TreeParametersObject
extends MultipleVariables {
    IntegerVariable nTree;
    int nbNodes;
    TreeNodeObject[] nodes;
    IntegerVariable nproper;
    IntegerVariable objective;
    List<BitSet[]> graphs;
    List<int[][]> matrix;
    int[][] travel;

    public TreeParametersObject(int nbNodes, IntegerVariable nTree, IntegerVariable nproper, IntegerVariable objective, List<BitSet[]> graphs, List<int[][]> matrix, int[][] travel) {
        this.nTree = nTree;
        this.addVariable(nTree);
        this.nbNodes = nbNodes;
        this.nproper = nproper;
        this.addVariable(nproper);
        this.objective = objective;
        this.addVariable(objective);
        this.graphs = graphs;
        this.matrix = matrix;
        this.travel = travel;
        this.nodes = new TreeNodeObject[this.nbNodes];
        for (int i = 0; i < this.nbNodes; ++i) {
            this.nodes[i] = new TreeNodeObject(i, nbNodes, graphs, matrix);
            this.addVariable(this.nodes[i]);
        }
    }

    @Override
    public String pretty() {
        return null;
    }

    public IntegerVariable[] getSuccVars() {
        IntegerVariable[] succVars = new IntegerVariable[this.nbNodes];
        for (int i = 0; i < succVars.length; ++i) {
            succVars[i] = this.nodes[i].getSuccessors();
        }
        return succVars;
    }

    public IntegerVariable getNTree() {
        return this.nTree;
    }

    public int getNbNodes() {
        return this.nbNodes;
    }

    public TreeNodeObject[] getNodes() {
        return this.nodes;
    }

    public IntegerVariable getNproper() {
        return this.nproper;
    }

    public IntegerVariable getObjective() {
        return this.objective;
    }

    public List<BitSet[]> getGraphs() {
        return this.graphs;
    }

    public List<int[][]> getMatrix() {
        return this.matrix;
    }

    public int[][] getTravel() {
        return this.travel;
    }
}

