/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables.tree;

import choco.Choco;
import choco.kernel.model.variables.MultipleVariables;
import choco.kernel.model.variables.integer.IntegerVariable;
import java.util.BitSet;
import java.util.List;

public class TreeNodeObject
extends MultipleVariables {
    protected int idx;
    protected IntegerVariable successors;
    protected IntegerVariable inDegree;
    protected IntegerVariable timeWindow;

    public TreeNodeObject(int idx, int nbNodes, List<BitSet[]> graphs, List<int[][]> matrix) {
        this.idx = idx;
        this.successors = Choco.makeIntVar("next_" + idx, 0, nbNodes - 1, "cp:enum");
        for (int i = 0; i < nbNodes; ++i) {
            if (graphs.get(0)[idx].get(i)) continue;
            this.successors.removeVal(i);
        }
        this.inDegree = Choco.makeIntVar("deg_" + idx, matrix.get(0)[idx][0], matrix.get(0)[idx][1], "cp:bound");
        this.timeWindow = Choco.makeIntVar("tw_" + idx, matrix.get(1)[idx][0], matrix.get(1)[idx][1], "cp:bound");
        this.addVariable(this.successors);
        this.addVariable(this.inDegree);
        this.addVariable(this.timeWindow);
    }

    @Override
    public String pretty() {
        return null;
    }

    public IntegerVariable getSuccessors() {
        return this.successors;
    }

    public int getIdx() {
        return this.idx;
    }

    public IntegerVariable getInDegree() {
        return this.inDegree;
    }

    public IntegerVariable getTimeWindow() {
        return this.timeWindow;
    }
}

