/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables.set;

import choco.kernel.model.Model;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.Operator;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.set.SetExpressionVariable;
import java.util.Iterator;

public class SetVariable
extends SetExpressionVariable {
    protected int[] values;
    protected IntegerVariable card;

    public SetVariable(String name, VariableType type, int lowB, int uppB, IntegerVariable card) {
        super((Object)new Object[]{new int[]{lowB, uppB}, card}, Operator.NONE, type, new SetExpressionVariable[0]);
        this.name = name;
        this.setLowB(lowB);
        this.setUppB(uppB);
        this.card = card;
    }

    public SetVariable(String name, VariableType type, int[] values, IntegerVariable card) {
        super((Object)new Object[]{values, card}, Operator.NONE, type, null);
        this.name = name;
        this.values = new int[values.length];
        System.arraycopy(values, 0, this.values, 0, values.length);
        if (values.length > 0) {
            this.setLowB(values[0]);
            this.setUppB(values[values.length - 1]);
        }
        this.card = card;
    }

    public final IntegerVariable getCard() {
        return this.card;
    }

    public final void setCard(IntegerVariable card) {
        this.card = card;
    }

    public int[] getValues() {
        return this.values;
    }

    @Override
    public String pretty() {
        return this.name + " [" + this.getLowB() + ", " + this.getUppB() + "]";
    }

    @Override
    public void addConstraint(Constraint c) {
        this.constraints.add(c);
    }

    @Override
    public void removeConstraint(Constraint c) {
        this.constraints.remove(c);
    }

    @Override
    @Deprecated
    public Iterator<Constraint> getConstraintIterator() {
        return this.constraints.iterator();
    }

    @Override
    public Iterator<Constraint> getConstraintIterator(final Model m) {
        return new Iterator<Constraint>(){
            Constraint c;
            Iterator<Constraint> it;
            {
                this.it = SetVariable.this.constraints.iterator();
            }

            @Override
            public boolean hasNext() {
                block2: {
                    do {
                        if (this.it == null) {
                            return false;
                        }
                        if (!this.it.hasNext()) break block2;
                        this.c = this.it.next();
                    } while (!Boolean.TRUE.equals(this.c.alreadyIn(m.getIndex())));
                    return true;
                }
                return false;
            }

            @Override
            public Constraint next() {
                return this.c;
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    @Override
    public void addOption(String option) {
        this.card.addOption(option);
        super.addOption(option);
    }

    @Override
    public Variable[] extractVariables() {
        if (this.listVars == null) {
            this.listVars = new Variable[]{this};
        }
        return this.listVars;
    }
}

