/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables.set;

import choco.kernel.common.util.ChocoUtil;
import choco.kernel.model.variables.ComponentVariable;
import choco.kernel.model.variables.IntBoundedVariable;
import choco.kernel.model.variables.Operator;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;

public class SetExpressionVariable
extends ComponentVariable
implements IntBoundedVariable {
    private int lowB;
    private int uppB;

    public SetExpressionVariable(Object parameters, Operator operator, VariableType type, SetExpressionVariable ... variables) {
        super(type, operator, parameters, "", (ComponentVariable[])variables);
    }

    public SetExpressionVariable(Object parameters, Operator operator, SetExpressionVariable ... variables) {
        this(parameters, operator, VariableType.SET_EXPRESSION, variables);
    }

    public SetExpressionVariable[] getVariables() {
        return (SetExpressionVariable[])this.variables;
    }

    @Override
    public int getLowB() {
        return this.lowB;
    }

    @Override
    public void setLowB(int lowB) {
        this.lowB = lowB;
    }

    @Override
    public int getUppB() {
        return this.uppB;
    }

    @Override
    public void setUppB(int uppB) {
        this.uppB = uppB;
    }

    private void computeBounds() {
        this.lowB = Integer.MAX_VALUE;
        this.uppB = Integer.MIN_VALUE;
        if (!(this.operator.equals((Object)Operator.SUM) || this.operator.equals((Object)Operator.SCALAR) || this.operator.equals((Object)Operator.NONE))) {
            int[] val = this.computeByOperator(0, 1);
            this.lowB = val[0] < this.lowB ? val[0] : this.lowB;
            this.uppB = val[1] > this.uppB ? val[1] : this.uppB;
        }
    }

    private int[] computeByOperator(int i, int j) {
        int i1 = ((SetExpressionVariable)this.variables[i]).getLowB();
        int i2 = ((SetExpressionVariable)this.variables[j]).getLowB();
        int s1 = ((SetExpressionVariable)this.variables[i]).getUppB();
        int s2 = ((SetExpressionVariable)this.variables[i]).getUppB();
        int[] vals = new int[4];
        switch (this.operator) {
            case MINUS: {
                vals[0] = i1 - i2;
                vals[1] = i1 - s2;
                vals[2] = s1 - i2;
                vals[3] = s1 - s2;
                break;
            }
            case MULT: {
                vals[0] = i1 * i2;
                vals[1] = i1 * s2;
                vals[2] = s1 * i2;
                vals[3] = s1 * s2;
                break;
            }
            case NONE: {
                break;
            }
            case PLUS: {
                vals[0] = i1 + i2;
                vals[1] = i1 + s2;
                vals[2] = s1 + i2;
                vals[3] = s1 + s2;
                break;
            }
            default: {
                vals[0] = Integer.MIN_VALUE;
                vals[1] = Integer.MIN_VALUE;
                vals[2] = Integer.MAX_VALUE;
                vals[3] = Integer.MAX_VALUE;
            }
        }
        int[] bounds = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        for (int k = 0; k < vals.length; ++k) {
            int val = vals[k];
            bounds[0] = Math.min(bounds[0], val);
            bounds[1] = Math.max(bounds[1], val);
        }
        return bounds;
    }

    @Override
    public Variable[] extractVariables() {
        if (this.listVars == null) {
            this.listVars = ChocoUtil.getNonRedundantObjects(Variable.class, this.variables);
        }
        return this.listVars;
    }
}

