/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables.set;

import choco.kernel.model.ModelException;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.set.SetVariable;

public class SetConstantVariable
extends SetVariable {
    public SetConstantVariable(String name, IntegerConstantVariable card, int ... value) {
        super(name, VariableType.CONSTANT_SET, value, card);
    }

    public SetConstantVariable(IntegerConstantVariable card, int ... value) {
        this("setCst", card, value);
    }

    @Override
    public int[] getValues() {
        return this.values;
    }

    @Override
    public int getLowB() {
        if (this.values.length > 0) {
            return this.values[0];
        }
        throw new ModelException("Cannot access lower bound of an empty set");
    }

    @Override
    public int getUppB() {
        if (this.values.length > 0) {
            return this.values[this.values.length - 1];
        }
        throw new ModelException("Cannot access lower bound of an empty set");
    }

    @Override
    public String pretty() {
        StringBuffer sb = new StringBuffer(this.name);
        sb.append("{");
        for (int i = 0; i < this.values.length; ++i) {
            sb.append(i);
            if (i >= this.values.length - 1) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof SetConstantVariable) {
            return this.values == ((SetConstantVariable)o).getValues();
        }
        return false;
    }
}

