/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables.scheduling;

import choco.kernel.model.ModelException;
import choco.kernel.model.variables.IComponentVariable;
import choco.kernel.model.variables.MultipleVariables;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.scheduling.ITaskVariable;
import java.util.Properties;

public class TaskVariable
extends MultipleVariables
implements IComponentVariable,
ITaskVariable<IntegerVariable> {
    private int NO_HOOK;
    protected final String name;
    protected String variableManager;
    private int hook;

    public TaskVariable(String name, IntegerVariable start, IntegerVariable end, IntegerVariable duration) {
        super(3);
        this.hook = this.NO_HOOK = -1;
        this.variables.add(start);
        this.variables.add(end);
        this.variables.add(duration);
        this.name = name;
        this.stored = true;
    }

    @Override
    public String getComponentClass() {
        return this.variableManager;
    }

    @Override
    public IntegerVariable duration() {
        return (IntegerVariable)this.variables.get(2);
    }

    @Override
    public IntegerVariable end() {
        return (IntegerVariable)this.variables.get(1);
    }

    @Override
    public IntegerVariable start() {
        return (IntegerVariable)this.variables.get(0);
    }

    public final String getName() {
        return this.name;
    }

    public int getHook() {
        return this.hook;
    }

    public void setHook(int hook) {
        if (this.hook != this.NO_HOOK) {
            new ModelException("hook already used");
        } else if (hook == this.NO_HOOK) {
            new ModelException("invalid hook value:" + hook);
        } else {
            this.hook = hook;
        }
    }

    @Override
    public String pretty() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.name).append(" {").append(this.start().pretty());
        buffer.append(" + ").append(this.duration().pretty());
        buffer.append(" = ").append(this.end().pretty());
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public final void findManager(Properties propertiesFile) {
        if (this.variableManager == null) {
            this.variableManager = propertiesFile.getProperty(VariableType.TASK.property);
        }
        if (this.variableManager == null) {
            throw new ModelException("Can not find " + this.type.property + " in application.properties");
        }
        super.findManager(propertiesFile);
    }
}

