/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables.integer;

import choco.kernel.common.util.IntIterator;
import choco.kernel.model.Model;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.Operator;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import java.util.Iterator;

public class IntegerVariable
extends IntegerExpressionVariable {
    protected int[] values;
    protected Object hook;

    public IntegerVariable(String name, VariableType type, int binf, int bsup) {
        super((Object)new int[]{binf, bsup}, Operator.NONE, type, null);
        this.name = name;
        this.setLowB(binf);
        this.setUppB(bsup);
    }

    public IntegerVariable(String name, VariableType type, int[] values) {
        super((Object)values, Operator.NONE, type, null);
        this.name = name;
        this.values = new int[values.length];
        System.arraycopy(values, 0, this.values, 0, values.length);
        this.setLowB(values[0]);
        this.setUppB(values[values.length - 1]);
    }

    public int[] getValues() {
        return this.values;
    }

    public int getDomainSize() {
        if (this.values != null) {
            return this.values.length;
        }
        return this.getUppB() - this.getLowB() + 1;
    }

    public boolean canBeEqualTo(int v) {
        if (this.values != null) {
            for (int value : this.values) {
                if (value != v) continue;
                return true;
            }
            return false;
        }
        return v >= this.getLowB() && v <= this.getUppB();
    }

    public boolean isBoolean() {
        return this.getLowB() == 0 && this.getUppB() == 1 || this.getLowB() == 0 && this.getUppB() == 0 || this.getLowB() == 1 && this.getUppB() == 1;
    }

    public boolean isConstant() {
        return this.getLowB() == this.getUppB();
    }

    @Override
    public String pretty() {
        return this.name + " [" + this.getLowB() + ", " + this.getUppB() + "]";
    }

    @Override
    public void addConstraint(Constraint c) {
        this.constraints.add(c);
    }

    @Override
    public void removeConstraint(Constraint c) {
        this.constraints.remove(c);
    }

    @Override
    @Deprecated
    public Iterator<Constraint> getConstraintIterator() {
        return this.constraints.iterator();
    }

    @Override
    public Iterator<Constraint> getConstraintIterator(final Model m) {
        return new Iterator<Constraint>(){
            Constraint c;
            Iterator<Constraint> it;
            {
                this.it = IntegerVariable.this.constraints.iterator();
            }

            @Override
            public boolean hasNext() {
                block2: {
                    do {
                        if (this.it == null) {
                            return false;
                        }
                        if (!this.it.hasNext()) break block2;
                        this.c = this.it.next();
                    } while (!Boolean.TRUE.equals(this.c.alreadyIn(m.getIndex())));
                    return true;
                }
                return false;
            }

            @Override
            public Constraint next() {
                return this.c;
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    public Object getHook() {
        return this.hook;
    }

    public void setHook(Object hook) {
        if (hook == null) {
            throw new ModelException("hook already used");
        }
        this.hook = hook;
    }

    public IntIterator getDomainIterator() {
        return new DomainIterator();
    }

    @Override
    public Variable[] extractVariables() {
        return this.variables;
    }

    @Override
    public IntegerExpressionVariable[] getVariables() {
        return new IntegerVariable[]{this};
    }

    public void removeVal(int remvalue) {
        if (this.canBeEqualTo(remvalue)) {
            int[] vals;
            int size;
            if (this.values == null) {
                size = this.getUppB() - this.getLowB();
                vals = new int[size];
                int idx = 0;
                int val = this.getLowB();
                while (idx < size) {
                    if (val != remvalue) {
                        vals[idx++] = val;
                    }
                    ++val;
                }
            } else {
                size = this.values.length - 1;
                vals = new int[size];
                int idx = 0;
                for (int value : this.values) {
                    if (value == remvalue) continue;
                    vals[idx++] = value;
                }
            }
            this.values = vals;
            this.setLowB(this.values[0]);
            this.setUppB(this.values[size - 1]);
        }
    }

    public int[] enumVal() {
        if (this.values == null) {
            int[] val = new int[this.getUppB() - this.getLowB() + 1];
            for (int o = 0; o < val.length; ++o) {
                val[o] = this.getLowB() + o;
            }
            return val;
        }
        if (this.values.length == 2 && this.values[0] == this.values[1]) {
            return new int[]{this.values[0]};
        }
        return this.values;
    }

    public class DomainIterator
    implements IntIterator {
        public int idx = 0;
        public int currentVal;

        public DomainIterator() {
            this.currentVal = IntegerVariable.this.getLowB();
        }

        @Override
        public boolean hasNext() {
            if (IntegerVariable.this.values == null) {
                return this.currentVal <= IntegerVariable.this.getUppB();
            }
            return this.idx < IntegerVariable.this.values.length;
        }

        @Override
        public int next() {
            if (IntegerVariable.this.values == null) {
                return this.currentVal++;
            }
            return IntegerVariable.this.values[this.idx++];
        }

        @Override
        public void remove() {
            throw new ModelException("can not removed values this way");
        }
    }
}

