/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables.integer;

import choco.kernel.common.util.ChocoUtil;
import choco.kernel.model.variables.ComponentVariable;
import choco.kernel.model.variables.IntBoundedVariable;
import choco.kernel.model.variables.Operator;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerConstantVariable;

public class IntegerExpressionVariable
extends ComponentVariable
implements IntBoundedVariable {
    private int lowB;
    private int uppB;

    public IntegerExpressionVariable(Object parameters, Operator operator, VariableType type, IntegerExpressionVariable ... variables) {
        super(type, operator, parameters, "", (ComponentVariable[])variables);
        this.init();
    }

    public IntegerExpressionVariable(Object parameters, String operator, VariableType type, IntegerExpressionVariable ... variables) {
        super(type, operator, parameters, "", (ComponentVariable[])variables);
        this.init();
    }

    public IntegerExpressionVariable(Object parameters, Class operator, VariableType type, IntegerExpressionVariable ... variables) {
        this(parameters, operator.getName(), type, variables);
    }

    public IntegerExpressionVariable(Object parameters, Operator operator, IntegerExpressionVariable ... variables) {
        this(parameters, operator, VariableType.INTEGER_EXPRESSION, variables);
    }

    public IntegerExpressionVariable(Object parameters, String operator, IntegerExpressionVariable ... variables) {
        super(VariableType.INTEGER_EXPRESSION, operator, parameters, "", (ComponentVariable[])variables);
        this.init();
    }

    public IntegerExpressionVariable(Object parameters, Class operator, IntegerExpressionVariable ... variables) {
        this(parameters, operator.getName(), variables);
    }

    private void init() {
        if (this.operator != null) {
            this.computeBounds();
        }
    }

    public IntegerExpressionVariable[] getVariables() {
        return (IntegerExpressionVariable[])this.variables;
    }

    public void setVariables(IntegerExpressionVariable[] variables) {
        this.variables = variables;
    }

    @Override
    public int getLowB() {
        return this.lowB;
    }

    @Override
    public void setLowB(int lowB) {
        this.lowB = lowB;
    }

    @Override
    public int getUppB() {
        return this.uppB;
    }

    @Override
    public void setUppB(int uppB) {
        this.uppB = uppB;
    }

    private void computeBounds() {
        this.lowB = Integer.MAX_VALUE;
        this.uppB = Integer.MIN_VALUE;
        switch (this.operator.parameters) {
            case 0: {
                int[] val = this.computeByNOperator();
                this.lowB = val[0] < this.lowB ? val[0] : this.lowB;
                this.uppB = val[1] > this.uppB ? val[1] : this.uppB;
                break;
            }
            case 1: {
                int[] val = this.computeByOperator(0);
                this.lowB = val[0] < this.lowB ? val[0] : this.lowB;
                this.uppB = val[1] > this.uppB ? val[1] : this.uppB;
                break;
            }
            case 2: {
                int[] val = this.computeByOperator(0, 1);
                this.lowB = val[0] < this.lowB ? val[0] : this.lowB;
                this.uppB = val[1] > this.uppB ? val[1] : this.uppB;
                break;
            }
        }
    }

    private int[] computeByOperator(int i) {
        int i1 = ((IntegerExpressionVariable)this.variables[i]).getLowB();
        int s1 = ((IntegerExpressionVariable)this.variables[i]).getUppB();
        int[] vals = new int[2];
        switch (this.operator) {
            case ABS: {
                vals[0] = Math.min(Math.abs(i1), Math.abs(s1));
                if (i1 < 0 && s1 > 0) {
                    vals[0] = 0;
                }
                vals[1] = Math.max(Math.abs(i1), Math.abs(s1));
                break;
            }
            case NEG: {
                vals[0] = -s1;
                vals[1] = -i1;
                break;
            }
            case NONE: {
                break;
            }
            default: {
                vals[0] = Integer.MIN_VALUE;
                vals[1] = Integer.MAX_VALUE;
            }
        }
        return vals;
    }

    private int[] computeByOperator(int i, int j) {
        int i1 = ((IntegerExpressionVariable)this.variables[i]).getLowB();
        int i2 = ((IntegerExpressionVariable)this.variables[j]).getLowB();
        int s1 = ((IntegerExpressionVariable)this.variables[i]).getUppB();
        int s2 = ((IntegerExpressionVariable)this.variables[j]).getUppB();
        int[] vals = new int[4];
        switch (this.operator) {
            case MINUS: {
                vals[0] = i1 - i2;
                vals[1] = i1 - s2;
                vals[2] = s1 - i2;
                vals[3] = s1 - s2;
                break;
            }
            case MOD: {
                if (i2 == 0 && s2 == 0) {
                    vals[0] = Integer.MIN_VALUE;
                    vals[1] = Integer.MIN_VALUE;
                    vals[2] = Integer.MAX_VALUE;
                    vals[3] = Integer.MAX_VALUE;
                    break;
                }
                if (s2 == 0) {
                    s2 = 1;
                }
                if (i2 == 0) {
                    i2 = 1;
                }
                vals[0] = i1 % i2;
                vals[1] = i1 % s2;
                vals[2] = s1 % i2;
                vals[3] = s1 % s2;
                break;
            }
            case MULT: {
                vals[0] = i1 * i2;
                vals[1] = i1 * s2;
                vals[2] = s1 * i2;
                vals[3] = s1 * s2;
                break;
            }
            case NONE: {
                break;
            }
            case PLUS: {
                vals[0] = i1 + i2;
                vals[1] = i1 + s2;
                vals[2] = s1 + i2;
                vals[3] = s1 + s2;
                break;
            }
            case POWER: {
                vals[0] = (int)Math.pow(i1, i2);
                vals[1] = (int)Math.pow(i1, s2);
                vals[2] = (int)Math.pow(s1, i2);
                vals[3] = (int)Math.pow(s1, s2);
                break;
            }
            default: {
                vals[0] = Integer.MIN_VALUE;
                vals[1] = Integer.MIN_VALUE;
                vals[2] = Integer.MAX_VALUE;
                vals[3] = Integer.MAX_VALUE;
            }
        }
        int[] bounds = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        for (int k = 0; k < vals.length; ++k) {
            int val = vals[k];
            bounds[0] = Math.min(bounds[0], val);
            bounds[1] = Math.max(bounds[1], val);
        }
        return bounds;
    }

    private int[] computeByNOperator() {
        int i1 = 0;
        int s1 = 0;
        int i = 0;
        int[] vals = new int[4];
        switch (this.operator) {
            case SCALAR: {
                int cste = this.variables.length / 2;
                do {
                    int val2 = ((IntegerConstantVariable)this.variables[i]).getValue();
                    int i2 = ((IntegerExpressionVariable)this.variables[i + cste]).getLowB() * val2;
                    int s2 = ((IntegerExpressionVariable)this.variables[i + cste]).getUppB() * val2;
                    vals[0] = i1 + i2;
                    vals[1] = i1 + s2;
                    vals[2] = s1 + i2;
                    vals[3] = s1 + s2;
                    i1 = Integer.MAX_VALUE;
                    s1 = Integer.MIN_VALUE;
                    for (int k = 0; k < vals.length; ++k) {
                        int val = vals[k];
                        i1 = Math.min(i1, val);
                        s1 = Math.max(s1, val);
                    }
                } while (++i < cste);
                break;
            }
            case SUM: {
                do {
                    int i2 = ((IntegerExpressionVariable)this.variables[i]).getLowB();
                    int s2 = ((IntegerExpressionVariable)this.variables[i]).getUppB();
                    vals[0] = i1 + i2;
                    vals[1] = i1 + s2;
                    vals[2] = s1 + i2;
                    vals[3] = s1 + s2;
                    i1 = Integer.MAX_VALUE;
                    s1 = Integer.MIN_VALUE;
                    for (int k = 0; k < vals.length; ++k) {
                        int val = vals[k];
                        i1 = Math.min(i1, val);
                        s1 = Math.max(s1, val);
                    }
                } while (++i < this.variables.length);
                break;
            }
            case MAX: {
                i1 = Integer.MIN_VALUE;
                s1 = Integer.MIN_VALUE;
                for (int j = 0; j < this.variables.length; ++j) {
                    int i2 = ((IntegerExpressionVariable)this.variables[j]).getLowB();
                    int s2 = ((IntegerExpressionVariable)this.variables[j]).getUppB();
                    i1 = Math.max(i1, i2);
                    s1 = Math.max(s1, s2);
                }
                break;
            }
            case MIN: {
                i1 = Integer.MAX_VALUE;
                s1 = Integer.MAX_VALUE;
                for (int j = 0; j < this.variables.length; ++j) {
                    int i2 = ((IntegerExpressionVariable)this.variables[j]).getLowB();
                    int s2 = ((IntegerExpressionVariable)this.variables[j]).getUppB();
                    i1 = Math.min(i1, i2);
                    s1 = Math.min(s1, s2);
                }
                break;
            }
            default: {
                i1 = Integer.MIN_VALUE;
                s1 = Integer.MAX_VALUE;
            }
        }
        return new int[]{i1, s1};
    }

    @Override
    public Variable[] extractVariables() {
        if (this.listVars == null) {
            this.listVars = ChocoUtil.getNonRedundantObjects(Variable.class, this.variables);
        }
        return this.listVars;
    }
}

