/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables.integer;

import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerVariable;

public class IntegerConstantVariable
extends IntegerVariable
implements Comparable {
    public IntegerConstantVariable(String name, int value) {
        super(name, VariableType.CONSTANT_INTEGER, value, value);
        this.values = new int[]{value};
    }

    public IntegerConstantVariable(int value) {
        this("intCst", value);
    }

    public int getValue() {
        return this.values[0];
    }

    public boolean equals(Object o) {
        if (o instanceof IntegerConstantVariable) {
            return this.getValue() == ((IntegerConstantVariable)o).getValue();
        }
        return false;
    }

    @Override
    public String pretty() {
        return this.name + " [" + this.getValue() + "]";
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof IntegerConstantVariable) {
            IntegerConstantVariable c = (IntegerConstantVariable)o;
            return this.getValue() - c.getValue();
        }
        return super.compareTo(o);
    }
}

