/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables;

import choco.kernel.common.util.ChocoUtil;
import choco.kernel.common.util.UtilAlgo;
import choco.kernel.model.Model;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.AbstractVariable;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;

public abstract class MultipleVariables
extends AbstractVariable {
    protected ArrayList<Variable> variables;
    protected boolean stored = false;

    protected MultipleVariables() {
        super(VariableType.MULTIPLE_VARIABLES);
        this.variables = new ArrayList();
    }

    protected MultipleVariables(int initialCapacity) {
        super(VariableType.MULTIPLE_VARIABLES);
        this.variables = new ArrayList(initialCapacity);
    }

    @Override
    public void addConstraint(Constraint c) {
        for (Variable variable : this.variables) {
            variable.addConstraint(c);
        }
    }

    @Override
    public void removeConstraint(Constraint c) {
        for (Variable variable : this.variables) {
            variable.removeConstraint(c);
        }
    }

    @Override
    @Deprecated
    public int getNbConstraint() {
        int val = 0;
        for (Variable variable : this.variables) {
            val += variable.getNbConstraint();
        }
        return val;
    }

    @Override
    public int getNbConstraint(Model m) {
        int val = 0;
        for (Variable variable : this.variables) {
            val += variable.getNbConstraint(m);
        }
        return val;
    }

    @Override
    @Deprecated
    public Iterator<Constraint> getConstraintIterator() {
        return new Iterator<Constraint>(){
            int numVar = 0;

            @Override
            public boolean hasNext() {
                while (this.numVar < MultipleVariables.this.variables.size() && !MultipleVariables.this.variables.get(this.numVar).getConstraintIterator().hasNext()) {
                    ++this.numVar;
                }
                return this.numVar < MultipleVariables.this.variables.size() && MultipleVariables.this.variables.get(this.numVar).getConstraintIterator().hasNext();
            }

            @Override
            public Constraint next() {
                return MultipleVariables.this.variables.get(this.numVar).getConstraintIterator().next();
            }

            @Override
            public void remove() {
                MultipleVariables.this.variables.get(this.numVar).getConstraintIterator().remove();
            }
        };
    }

    @Override
    public Iterator<Constraint> getConstraintIterator(final Model m) {
        return new Iterator<Constraint>(){
            int numVar = 0;

            @Override
            public boolean hasNext() {
                while (this.numVar < MultipleVariables.this.variables.size() && !MultipleVariables.this.variables.get(this.numVar).getConstraintIterator(m).hasNext()) {
                    ++this.numVar;
                }
                return this.numVar < MultipleVariables.this.variables.size() && MultipleVariables.this.variables.get(this.numVar).getConstraintIterator(m).hasNext();
            }

            @Override
            public Constraint next() {
                return MultipleVariables.this.variables.get(this.numVar).getConstraintIterator(m).next();
            }

            @Override
            public void remove() {
                MultipleVariables.this.variables.get(this.numVar).getConstraintIterator(m).remove();
            }
        };
    }

    @Deprecated
    public int getNbTotConstraint() {
        int val = 0;
        for (Variable variable : this.variables) {
            val += variable.getNbConstraint();
        }
        return val;
    }

    public int getNbTotConstraint(Model m) {
        int val = 0;
        for (Variable variable : this.variables) {
            val += variable.getNbConstraint(m);
        }
        return val;
    }

    public void addVariable(Variable var) {
        this.variables.add(var);
    }

    public void addVariables(ArrayList<Variable> var) {
        this.variables.addAll(var);
    }

    public void removeVariable(Variable var) {
        this.variables.remove(var);
    }

    public void removeVariables(ArrayList<Variable> var) {
        this.variables.removeAll(var);
    }

    public Variable getVariable(int i) {
        return this.variables.get(i);
    }

    public Variable[] getVariables() {
        Variable[] tabVar = new Variable[this.variables.size()];
        Arrays.copyOf(this.variables.toArray(tabVar), this.variables.size());
        return tabVar;
    }

    public Iterator<Variable> getVariableIterator() {
        return this.variables.iterator();
    }

    public int getNbVariables() {
        return this.variables.size();
    }

    public boolean isStored() {
        return this.stored;
    }

    @Override
    public Variable[] extractVariables() {
        if (this.listVars == null) {
            this.listVars = ChocoUtil.getNonRedundantObjects(Variable.class, UtilAlgo.toArray(Variable.class, this.variables));
        }
        return this.listVars;
    }

    @Override
    public void findManager(Properties properties) {
        for (Variable variable : this.variables) {
            variable.findManager(properties);
        }
    }
}

