/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables;

import choco.kernel.common.util.ChocoUtil;
import choco.kernel.model.Model;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ExpressionManager;
import choco.kernel.model.variables.AbstractVariable;
import choco.kernel.model.variables.IComponentVariable;
import choco.kernel.model.variables.Operator;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableManager;
import choco.kernel.model.variables.VariableType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public abstract class ComponentVariable
extends AbstractVariable
implements IComponentVariable {
    protected final Object parameters;
    protected String componentClass;
    protected String variableManager;
    protected String expressionManager;
    protected String name;
    protected Operator operator;
    protected ComponentVariable[] variables;
    protected final ArrayList<Constraint> constraints = new ArrayList();
    protected VariableManager vm;
    protected ExpressionManager em;

    public ComponentVariable(VariableType variableType, Operator operator, Object parameters, String name, ComponentVariable ... vars) {
        super(variableType);
        this.build(name, vars);
        this.parameters = parameters;
        this.operator = operator;
    }

    public ComponentVariable(VariableType variableType, String operatorManager, Object parameters, String name, ComponentVariable ... vars) {
        super(variableType);
        this.build(name, vars);
        this.parameters = parameters;
        this.expressionManager = operatorManager;
    }

    public ComponentVariable(VariableType variableType, Class operatorClass, Object parameters, String name, ComponentVariable ... vars) {
        super(variableType);
        this.build(name, vars);
        this.expressionManager = operatorClass.getName();
        this.parameters = parameters;
    }

    private void build(String name, ComponentVariable ... vars) {
        this.name = name;
        this.variables = vars;
    }

    @Override
    public String getComponentClass() {
        return this.variableManager;
    }

    public String getOperatorClass() {
        if (this.expressionManager != null) {
            return this.expressionManager;
        }
        return this.variableManager;
    }

    public Object getParameters() {
        return this.parameters;
    }

    public Variable[] getVariables() {
        return this.variables;
    }

    public final Variable getVariable(int idx) {
        return this.variables[idx];
    }

    public int getNbVars() {
        return this.variables.length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    @Override
    public void addConstraint(Constraint c) {
        if (this.variables == null) {
            this.constraints.add(c);
        } else {
            for (ComponentVariable v : this.variables) {
                v.addConstraint(c);
            }
        }
    }

    @Override
    public void removeConstraint(Constraint c) {
        if (this.variables == null) {
            this.constraints.remove(c);
        } else {
            for (ComponentVariable v : this.variables) {
                v.removeConstraint(c);
            }
        }
    }

    @Override
    @Deprecated
    public Iterator<Constraint> getConstraintIterator() {
        return new Iterator<Constraint>(){
            int n = 0;
            Iterator<Constraint> it;
            {
                this.it = ComponentVariable.this.variables != null ? ComponentVariable.this.variables[this.n].getConstraintIterator() : ComponentVariable.this.constraints.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.it == null) {
                    return false;
                }
                while (this.n < ComponentVariable.this.variables.length && !this.it.hasNext()) {
                    ++this.n;
                    if (this.n >= ComponentVariable.this.variables.length) continue;
                    this.it = ComponentVariable.this.variables[this.n].getConstraintIterator();
                }
                return this.n < ComponentVariable.this.variables.length && this.it.hasNext();
            }

            @Override
            public Constraint next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    @Override
    public Iterator<Constraint> getConstraintIterator(final Model m) {
        return new Iterator<Constraint>(){
            int n = 0;
            Iterator<Constraint> it;
            Constraint c;
            {
                this.it = ComponentVariable.this.variables != null ? ComponentVariable.this.variables[this.n].getConstraintIterator(m) : ComponentVariable.this.constraints.iterator();
                this.c = null;
            }

            @Override
            public boolean hasNext() {
                while (true) {
                    if (this.it == null) {
                        return false;
                    }
                    if (this.it.hasNext()) {
                        this.c = this.it.next();
                        if (!Boolean.TRUE.equals(this.c.alreadyIn(m.getIndex()))) continue;
                        return true;
                    }
                    if (this.n >= ComponentVariable.this.variables.length) break;
                    ++this.n;
                    if (this.n >= ComponentVariable.this.variables.length) continue;
                    this.it = ComponentVariable.this.variables[this.n].getConstraintIterator(m);
                }
                return false;
            }

            @Override
            public Constraint next() {
                return this.c;
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    public Iterator<Variable> getVariableIterator() {
        return ChocoUtil.iterator(this.extractVariables());
    }

    public Constraint[] getConstraints() {
        Constraint[] cstr = new Constraint[this.constraints.size()];
        this.constraints.toArray(cstr);
        return cstr;
    }

    public final Constraint getConstraint(int idx) {
        return this.constraints.get(idx);
    }

    @Override
    @Deprecated
    public int getNbConstraint() {
        if (this.variables == null) {
            return this.constraints.size();
        }
        int sum = 0;
        for (ComponentVariable v : this.variables) {
            sum = v.getNbConstraint();
        }
        return sum;
    }

    @Override
    public int getNbConstraint(Model m) {
        int sum = 0;
        if (this.variables == null) {
            for (Constraint c : this.constraints) {
                if (!Boolean.TRUE.equals(c.alreadyIn(m.getIndex()))) continue;
                ++sum;
            }
            return sum;
        }
        for (ComponentVariable v : this.variables) {
            sum = v.getNbConstraint(m);
        }
        return sum;
    }

    @Override
    public void findManager(Properties propertiesFile) {
        if (this.variableManager == null && !this.type.equals((Object)VariableType.NONE)) {
            this.variableManager = propertiesFile.getProperty(this.type.property);
        }
        if (this.expressionManager == null && !this.operator.equals((Object)Operator.NONE)) {
            this.expressionManager = propertiesFile.getProperty(this.operator.property);
        }
        if (this.variableManager == null && this.expressionManager == null) {
            throw new ModelException("Can not find " + this.type.property + " or " + this.operator.property + " in application.properties");
        }
    }

    public VariableManager getVm() {
        if (this.vm == null) {
            this.vm = (VariableManager)this.loadManager(this.getComponentClass());
        }
        return this.vm;
    }

    public Object loadManager(String manager) {
        Class<?> componentClass = null;
        try {
            componentClass = Class.forName(manager);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Component class could not be found: " + manager);
            System.exit(-1);
        }
        try {
            return componentClass.newInstance();
        }
        catch (InstantiationException e) {
            System.err.println("Component class could not be instantiated: " + manager);
            System.exit(-1);
        }
        catch (IllegalAccessException e) {
            System.err.println("Component class could not be accessed: " + manager);
            System.exit(-1);
        }
        return null;
    }

    public ExpressionManager getEm() {
        if (this.em == null) {
            this.em = (ExpressionManager)this.loadManager(this.getOperatorClass());
        }
        return this.em;
    }

    @Override
    public String pretty() {
        if (this.variables == null) {
            return this.name;
        }
        StringBuffer st = new StringBuffer();
        for (ComponentVariable v : this.variables) {
            st.append(v.pretty());
        }
        return st.toString();
    }
}

