/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables;

import choco.kernel.common.HashCoding;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import java.util.HashSet;
import java.util.Iterator;

public abstract class AbstractVariable
implements Variable,
Comparable {
    protected VariableType type;
    protected int hashCode;
    protected HashSet<String> options = new HashSet();
    protected Variable[] listVars;
    protected TIntArrayList modelIndexes;
    private TIntIntHashMap indexes;

    public AbstractVariable(VariableType type) {
        this.type = type;
        this.modelIndexes = new TIntArrayList(1);
        this.indexes = new TIntIntHashMap();
    }

    @Override
    public HashSet<String> getOptions() {
        return this.options;
    }

    @Override
    public void addOption(String opts) {
        if (opts != null && !"".equals(opts)) {
            String[] optionsStrings = opts.split(" ");
            for (int j = 0; j < optionsStrings.length; ++j) {
                String optionsString = optionsStrings[j];
                this.options.add(optionsString);
            }
        }
    }

    @Override
    public void addOptions(String[] options) {
        for (int o = 0; o < options.length; ++o) {
            this.addOption(options[o]);
        }
    }

    @Override
    public void addOptions(HashSet<String> tOptions) {
        if (tOptions != null) {
            Iterator<String> it = tOptions.iterator();
            while (it.hasNext()) {
                this.addOption(it.next());
            }
        }
    }

    @Override
    public final VariableType getVariableType() {
        return this.type;
    }

    public final void setType(VariableType type) {
        this.type = type;
    }

    public String toString() {
        return this.pretty();
    }

    public int hashCode() {
        return HashCoding.hashCodeMe(new Object[]{this.indexes});
    }

    @Override
    public int getIndexIn(int masterIndex) {
        if (this.indexes.containsKey(masterIndex)) {
            return this.indexes.get(masterIndex);
        }
        return -1;
    }

    @Override
    public void setIndexIn(int masterInd, int ind) {
        this.indexes.put(masterInd, ind);
    }

    @Override
    public Boolean alreadyIn(int modelIndex) {
        return this.modelIndexes.contains(modelIndex);
    }

    @Override
    public void addModelIndex(int modelIndex) {
        if (!this.modelIndexes.contains(modelIndex)) {
            this.modelIndexes.add(modelIndex);
        }
    }

    @Override
    public void remModelIndex(int modelIndex) {
        int ind = this.modelIndexes.indexOf(modelIndex);
        if (ind > -1) {
            this.modelIndexes.remove(ind);
        }
    }

    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        return 1;
    }
}

