/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints.pack;

import choco.Choco;
import choco.kernel.common.util.ChocoUtil;
import choco.kernel.common.util.IPermutation;
import choco.kernel.model.Model;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.set.SetVariable;
import java.util.LinkedList;
import java.util.List;

public class PackModeler {
    private static int nextIndex;
    public final int maxCapacity;
    public final int nbItems;
    public final int nbBins;
    public final IPermutation permutation;
    public final IntegerVariable[] bins;
    public final IntegerConstantVariable[] sizes;
    public final SetVariable[] itemSets;
    public final IntegerVariable[] loads;
    public final IntegerVariable nbNonEmpty;
    public IntegerVariable nbEmpty;
    private int nbPack;

    public PackModeler(IntegerVariable[] bins, IntegerConstantVariable[] sizes, SetVariable[] itemSets, IntegerVariable[] loads, IntegerVariable nbNonEmpty, int capacity) {
        this.bins = bins;
        this.nbBins = bins.length;
        this.sizes = sizes;
        this.nbItems = sizes.length;
        this.itemSets = itemSets;
        this.loads = loads;
        this.nbNonEmpty = nbNonEmpty;
        this.nbEmpty = Choco.makeIntVar("nbEmpty" + PackModeler.nextID(), 0, this.nbBins, "cp:bound");
        this.maxCapacity = capacity;
        this.permutation = ChocoUtil.getIdentity();
    }

    public PackModeler(int[] sizes, int nbBins, int capacity) {
        this(PackModeler.nextID(), sizes, nbBins, capacity);
    }

    public PackModeler(String name, int[] sizes, int nbBins, int capacity) {
        this(name, Choco.constantArray(sizes), nbBins, capacity);
    }

    public PackModeler(String name, IntegerConstantVariable[] sizes, int nbBins, int capacity) {
        this.maxCapacity = capacity;
        this.nbItems = sizes.length;
        this.nbBins = nbBins;
        this.bins = Choco.makeIntVarArray("bin-" + name, this.nbItems, 0, this.nbBins - 1, "cp:enum");
        this.itemSets = Choco.makeSetVarArray("itemSet-" + name, this.nbBins, 0, this.nbItems - 1, "cp:bound");
        this.loads = Choco.makeIntVarArray("load-" + name, this.nbBins, 0, this.maxCapacity, "cp:bound");
        this.nbNonEmpty = Choco.makeIntVar("nbNonEmpty-" + name, 0, this.nbBins, "cp:bound");
        this.nbEmpty = Choco.makeIntVar("nbEmpty-" + name, 0, this.nbBins, "cp:bound");
        IPermutation tmp = ChocoUtil.getSortingPermuation(sizes, true);
        this.permutation = tmp.isIdentity() ? ChocoUtil.getIdentity() : tmp;
        this.sizes = ChocoUtil.applyPermutation(this.permutation, sizes);
    }

    private static String nextID() {
        return "pack" + String.valueOf(nextIndex++);
    }

    protected void setNoDecision(Variable v) {
        v.addOption("cp:no_decision");
    }

    public void setDefaultDecisionVariable() {
        for (int b = 0; b < this.nbBins; ++b) {
            this.setNoDecision(this.loads[b]);
            this.setNoDecision(this.itemSets[b].getCard());
        }
        this.setNoDecision(this.nbNonEmpty);
        this.setNoDecision(this.nbEmpty);
    }

    protected Constraint[] toArray(List<Constraint> cstr) {
        return cstr.toArray(new Constraint[cstr.size()]);
    }

    public Constraint[] symBreakEqualSizedItems() {
        LinkedList<Constraint> cstr = new LinkedList<Constraint>();
        int v = -1;
        for (int idx = 0; idx < this.nbItems; ++idx) {
            int s = this.sizes[idx].getValue();
            if (s == v) {
                cstr.add(Choco.geq((IntegerExpressionVariable)this.bins[idx], (IntegerExpressionVariable)this.bins[idx - 1]));
                continue;
            }
            v = s;
        }
        return this.toArray(cstr);
    }

    public final Constraint[] redundantCstrNbNonEmptyBins() {
        return new Constraint[]{Choco.occurrence(0, this.nbEmpty, this.loads), Choco.eq(Choco.plus((IntegerExpressionVariable)this.nbEmpty, (IntegerExpressionVariable)this.nbNonEmpty), this.nbBins)};
    }

    public final Constraint[] symBreakPackLargeItems(boolean leqCstr) {
        LinkedList<Constraint> cstr = new LinkedList<Constraint>();
        this.nbPack = 0;
        while (this.nbPack < this.nbItems && this.sizes[this.nbPack].getValue() > this.maxCapacity / 2) {
            cstr.add(Choco.eq((IntegerExpressionVariable)this.bins[this.nbPack], this.nbPack));
            ++this.nbPack;
        }
        if (leqCstr) {
            int m = Math.min(this.nbBins, this.nbItems);
            while (this.nbPack < m) {
                cstr.add(Choco.leq((IntegerExpressionVariable)this.bins[this.nbPack], this.nbPack));
                ++this.nbPack;
            }
        }
        return this.toArray(cstr);
    }

    public final Constraint[] symBreakEndsWithEmptyBins(int begin, int end) {
        int size = end - begin;
        Constraint[] cstr = new Constraint[2 * size - 1];
        IntegerVariable[] b = Choco.makeIntVarArray("bool-empty", this.nbBins, 0, 1, new String[0]);
        int idx = 0;
        for (int i = begin; i < end; ++i) {
            int j = i - begin;
            cstr[idx++] = Choco.boolChanneling(b[j], this.loads[i], 0);
            if (i <= begin) continue;
            cstr[idx++] = Choco.geq((IntegerExpressionVariable)b[j], (IntegerExpressionVariable)b[j - 1]);
        }
        return cstr;
    }

    public final Constraint redundantCstrAllDiffLargeItems() {
        return this.redundantCstrAllDiffLargeItems(null);
    }

    public final Constraint redundantCstrAllDiffLargeItems(String option) {
        LinkedList<IntegerVariable> vars = new LinkedList<IntegerVariable>();
        int idx = 0;
        while (this.sizes[idx].getValue() > this.maxCapacity / 2) {
            vars.add(this.bins[idx]);
            ++idx;
        }
        IntegerVariable[] large = vars.toArray(new IntegerVariable[vars.size()]);
        return option == null ? Choco.allDifferent(large) : Choco.allDifferent(option, large);
    }

    protected IntegerVariable[] getCardinality() {
        IntegerVariable[] cards = new IntegerVariable[this.itemSets.length];
        for (int i = 0; i < this.itemSets.length; ++i) {
            cards[i] = this.itemSets[i].getCard();
        }
        return cards;
    }

    public final Constraint[] symBreakLoadOrdering(boolean breakTie) {
        return this.symBreakLoadOrdering(0, this.nbBins, breakTie);
    }

    public final Constraint[] symBreakLoadOrdering(int inf, int sup, boolean breakTie) {
        return this.symBreakOrdering(inf, sup, this.loads, breakTie ? this.getCardinality() : null);
    }

    public final Constraint[] symBreakOrdering(int inf, int sup, IntegerVariable[] vars, IntegerVariable[] breakTieVars) {
        boolean breakTie;
        int nb = sup - inf - 1;
        boolean bl = breakTie = breakTieVars != null;
        if (nb > 0) {
            int f = breakTie ? 2 : 1;
            Constraint[] cstr = new Constraint[f * nb];
            for (int i = inf; i < sup - 1; ++i) {
                int idx = i - inf;
                cstr[f * idx] = Choco.geq((IntegerExpressionVariable)vars[i], (IntegerExpressionVariable)vars[i + 1]);
                if (!breakTie) continue;
                cstr[f * idx + 1] = Choco.ifThenElse(Choco.eq((IntegerExpressionVariable)vars[i], (IntegerExpressionVariable)vars[i + 1]), Choco.geq((IntegerExpressionVariable)breakTieVars[i], (IntegerExpressionVariable)breakTieVars[i + 1]), Choco.TRUE);
            }
            return cstr;
        }
        return null;
    }

    public void packAll(Model model) {
        this.packAll(model, true, true);
    }

    public void packAll(Model model, boolean leqCstr, boolean breakTie) {
        model.addConstraints(this.symBreakPackLargeItems(leqCstr));
        Constraint[] ordering = this.symBreakLoadOrdering(this.nbPack, this.nbBins, breakTie);
        if (ordering != null) {
            model.addConstraints(ordering);
        }
    }

    public void sortAll(Model model) {
        this.sortAll(model, false, null);
    }

    public void sortAll(Model model, boolean breakTie, String option) {
        model.addConstraints(this.symBreakLoadOrdering(breakTie));
        model.addConstraints(this.redundantCstrAllDiffLargeItems(option));
    }
}

