/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints.automaton.FA;

import choco.kernel.common.util.UtilAlgo;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIterator;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;

public class Automaton {
    protected ArrayList<int[]> representedBy;
    protected TIntHashSet acceptingStates;
    protected int startingState;
    protected int nbStates;
    protected TIntArrayList symbols;
    protected TIntHashSet alphabet;
    protected TIntArrayList indexs;
    protected static TIntIntHashMap charFromIntMap = new TIntIntHashMap();
    protected static TIntIntHashMap intFromCharMap = new TIntIntHashMap();

    public static int getIntFromChar(int c) {
        return intFromCharMap.get(c);
    }

    public static int getCharFromInt(int i) {
        return charFromIntMap.get(i);
    }

    public Automaton() {
        this.symbols = new TIntArrayList(10);
        this.alphabet = new TIntHashSet(10);
        this.representedBy = new ArrayList();
        this.indexs = new TIntArrayList(10);
        this.nbStates = 0;
        this.acceptingStates = new TIntHashSet();
    }

    private Vector<State> orderState(dk.brics.automaton.Automaton a) {
        Vector<State> out = new Vector<State>();
        LinkedList<State> toVisit = new LinkedList<State>();
        toVisit.add(a.getInitialState());
        while (!toVisit.isEmpty()) {
            State tmp = (State)toVisit.remove();
            out.add(tmp);
            Set tr = tmp.getTransitions();
            for (Transition t : tr) {
                if (out.contains(t.getDest()) || toVisit.contains(t.getDest())) continue;
                toVisit.add(t.getDest());
            }
        }
        return out;
    }

    public Automaton(dk.brics.automaton.Automaton a) {
        this();
        Set dkStates = a.getStates();
        TObjectIntHashMap<State> ct = new TObjectIntHashMap<State>();
        Vector<State> tmp = this.orderState(a);
        for (State s : tmp) {
            ct.put(s, this.addState());
        }
        this.setStartingState(ct.get(a.getInitialState()));
        for (State s : dkStates) {
            int tmp1 = ct.get(s);
            if (s.isAccept()) {
                this.setAcceptingState(tmp1);
            }
            for (Transition t : s.getTransitions()) {
                int tmp2 = ct.get(t.getDest());
                for (int i = t.getMin(); i <= t.getMax(); ++i) {
                    this.addTransition(tmp1, tmp2, Automaton.getIntFromChar(i));
                }
            }
        }
    }

    public void fill(dk.brics.automaton.Automaton a, TIntHashSet alpha) {
        int amin = Automaton.min(alpha);
        int amax = Automaton.max(alpha);
        Set dkStates = a.getStates();
        TObjectIntHashMap<State> ct = new TObjectIntHashMap<State>();
        Vector<State> tmp = this.orderState(a);
        for (State s : tmp) {
            ct.put(s, this.addState());
        }
        this.setStartingState(ct.get(a.getInitialState()));
        for (State s : dkStates) {
            int tmp1 = ct.get(s);
            if (s.isAccept()) {
                this.setAcceptingState(tmp1);
            }
            for (Transition t : s.getTransitions()) {
                int tmp2 = ct.get(t.getDest());
                char imin = t.getMin();
                char imax = t.getMax();
                if (imax < amin || imin > amax) continue;
                for (int i = Math.max(imin, amin); i <= Math.min(imax, amax); ++i) {
                    int k = Automaton.getIntFromChar(i);
                    if (!alpha.contains(k)) continue;
                    this.addTransition(tmp1, tmp2, k);
                }
            }
        }
    }

    private static int min(TIntHashSet alpha) {
        int min = Integer.MAX_VALUE;
        TIntIterator it = alpha.iterator();
        while (it.hasNext()) {
            int tmp = it.next();
            if (tmp >= min) continue;
            min = tmp;
        }
        return min;
    }

    public static int max(TIntHashSet alpha) {
        int max = Integer.MIN_VALUE;
        TIntIterator it = alpha.iterator();
        while (it.hasNext()) {
            int tmp = it.next();
            if (tmp <= max) continue;
            max = tmp;
        }
        return max;
    }

    public Automaton(String regexp) {
        this(new RegExp(UtilAlgo.toCharExp(regexp)).toAutomaton());
    }

    public Automaton(Automaton auto) {
        int i;
        this.symbols = new TIntArrayList();
        this.symbols.ensureCapacity(auto.symbols.size());
        for (i = 0; i < auto.symbols.size(); ++i) {
            this.symbols.add(auto.symbols.get(i));
        }
        this.alphabet = new TIntHashSet(auto.alphabet.size());
        this.alphabet.addAll(this.alphabet.toArray());
        this.representedBy = new ArrayList();
        this.representedBy.ensureCapacity(auto.representedBy.size());
        for (i = 0; i < auto.representedBy.size(); ++i) {
            int[] old = auto.representedBy.get(i);
            int[] nt = new int[old.length];
            System.arraycopy(old, 0, nt, 0, old.length);
            this.representedBy.add(nt);
        }
        this.indexs = new TIntArrayList();
        this.indexs.ensureCapacity(auto.indexs.size());
        for (i = 0; i < auto.indexs.size(); ++i) {
            this.indexs.add(auto.indexs.get(i));
        }
        this.nbStates = auto.nbStates;
        this.acceptingStates = new TIntHashSet(auto.acceptingStates.size());
        this.acceptingStates.addAll(auto.acceptingStates.toArray());
        this.setStartingState(auto.getStartingState());
    }

    public int size() {
        return this.nbStates;
    }

    public int getNbSymbols() {
        return this.symbols.size();
    }

    public int addState() {
        ++this.nbStates;
        int[] tmp = new int[this.symbols.size()];
        Arrays.fill(tmp, -1);
        this.representedBy.add(tmp);
        return this.nbStates - 1;
    }

    public void remState(int s) {
        int[] aSt;
        this.representedBy.remove(s);
        this.acceptingStates.remove(s);
        --this.nbStates;
        for (int[] aRepresentedBy : this.representedBy) {
            for (int j = 0; j < aRepresentedBy.length; ++j) {
                int k = aRepresentedBy[j];
                if (k == s) {
                    aRepresentedBy[j] = -1;
                    continue;
                }
                if (k <= s) continue;
                aRepresentedBy[j] = k - 1;
            }
        }
        int start = this.getStartingState();
        if (start > s) {
            this.setStartingState(start - 1);
        }
        for (int k : aSt = this.acceptingStates.toArray()) {
            if (k <= s) continue;
            this.acceptingStates.remove(k);
            this.acceptingStates.add(k - 1);
        }
    }

    private int addSymbolToAutomaton(int symbol) {
        this.symbols.add(symbol);
        this.alphabet.add(symbol);
        if (symbol >= this.indexs.size()) {
            this.indexs.fill(this.indexs.size(), symbol + 1, -1);
        }
        this.indexs.set(symbol, this.symbols.size() - 1);
        for (int i = 0; i < this.representedBy.size(); ++i) {
            int[] tmp = this.representedBy.get(i);
            int[] newTab = new int[this.symbols.size()];
            System.arraycopy(tmp, 0, newTab, 0, tmp.length);
            newTab[this.symbols.size() - 1] = -1;
            this.representedBy.set(i, newTab);
        }
        return this.symbols.size() - 1;
    }

    public void addTransition(int source, int destination, int[] symbols) {
        for (int i : symbols) {
            this.addTransition(source, destination, i);
        }
    }

    public void addTransition(int source, int destination, int symbol) {
        int idx = symbol >= this.indexs.size() ? -1 : this.indexs.get(symbol);
        if (idx == -1) {
            idx = this.addSymbolToAutomaton(symbol);
        }
        if (source < this.representedBy.size() && destination < this.representedBy.size()) {
            this.representedBy.get((int)source)[idx] = destination;
        } else {
            System.err.println("state does not exist... not adding transition");
        }
    }

    public void deleteTransition(int source, int destination, int symbol) {
        int idx = this.indexs.get(symbol);
        if (idx != -1 && source < this.representedBy.size() && destination < this.representedBy.size()) {
            this.representedBy.get((int)source)[idx] = -1;
        } else {
            System.err.println("Symbol or state does not exist");
        }
    }

    public int delta(int source, int symbol) {
        if (symbol >= this.indexs.size()) {
            return -1;
        }
        int idx = this.indexs.get(symbol);
        if (idx == -1 || source >= this.nbStates) {
            return -1;
        }
        return this.representedBy.get(source)[idx];
    }

    public Automaton opposite() {
        Automaton out = new Automaton(this);
        int fs = out.addState();
        for (int q = 0; q < out.representedBy.size(); ++q) {
            if (this.isAccepting(q)) {
                out.setNonAcceptingState(q);
            } else {
                out.setAcceptingState(q);
            }
            TIntIterator it = this.alphabet.iterator();
            while (it.hasNext()) {
                int a = it.next();
                if (this.delta(q, a) != -1) continue;
                out.addTransition(q, fs, a);
            }
        }
        return out;
    }

    public void addToAlphabet(int a) {
        this.alphabet.add(a);
    }

    public int getStartingState() {
        return this.startingState;
    }

    public boolean isAccepting(int state) {
        return this.acceptingStates.contains(state);
    }

    public void setStartingState(int state) {
        this.startingState = state;
    }

    public void setAcceptingState(int state) {
        this.acceptingStates.add(state);
    }

    public void setNonAcceptingState(int state) {
        this.acceptingStates.remove(state);
    }

    public boolean run(int[] word) {
        int start = this.getStartingState();
        return this.run(start, word);
    }

    private boolean run(int state, int[] word) {
        if (word.length == 1) {
            int last = this.delta(state, word[0]);
            return last >= 0 && this.isAccepting(last);
        }
        int first = word[0];
        int next = this.delta(state, first);
        if (next >= 0) {
            int[] queue = new int[word.length - 1];
            System.arraycopy(word, 1, queue, 0, queue.length);
            return this.run(next, queue);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("          ");
        for (int m = 0; m < this.symbols.size(); ++m) {
            int token = this.symbols.get(m);
            sb.append(token);
            for (int i = 0; i < 9 - ("" + token).length(); ++i) {
                sb.append(" ");
            }
        }
        sb.append("\n");
        for (int state = 0; state < this.representedBy.size(); ++state) {
            int tmpL = 0;
            if (this.getStartingState() == state) {
                sb.append("->");
                tmpL += 2;
            }
            if (this.isAccepting(state)) {
                sb.append("*");
                ++tmpL;
            }
            sb.append("q").append(state);
            tmpL += Integer.toString(state).length();
            for (int m = 0; m < this.symbols.size(); ++m) {
                int token = this.symbols.get(m);
                int next = this.delta(state, token);
                for (int i = 0; i < 9 - tmpL; ++i) {
                    sb.append(" ");
                }
                String symb = next == -1 ? " @ " : "[q" + next + "]";
                tmpL = symb.length();
                sb.append(symb);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public int getNbStates() {
        return this.nbStates;
    }

    private TIntObjectHashMap<TIntObjectHashMap<TIntHashSet>> makeMap() {
        TIntObjectHashMap<TIntObjectHashMap<TIntHashSet>> out = new TIntObjectHashMap<TIntObjectHashMap<TIntHashSet>>();
        for (int i = 0; i < this.nbStates; ++i) {
            for (int m = 0; m < this.symbols.size(); ++m) {
                int s = this.symbols.get(m);
                int tmp = this.delta(i, s);
                if (tmp < 0) continue;
                if (out.get(i) == null) {
                    out.put(i, new TIntObjectHashMap());
                }
                if (out.get(i).get(tmp) == null) {
                    out.get(i).put(tmp, new TIntHashSet());
                }
                out.get(i).get(tmp).add(s);
            }
        }
        return out;
    }

    public void toDotty(String f) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File(f)));
            bw.write("digraph finite_state_machine {");
            bw.newLine();
            bw.write("rankdir=LR;");
            bw.newLine();
            bw.write("node [shape = circle];");
            bw.newLine();
            bw.write("init [shape = plaintext,label=\"\"];");
            bw.newLine();
            bw.write("init -> " + this.getStartingState());
            bw.newLine();
            for (int i = 0; i < this.nbStates; ++i) {
                if (!this.isAccepting(i)) continue;
                bw.write(i + " [shape = doublecircle];");
                bw.newLine();
            }
            TIntObjectHashMap<TIntObjectHashMap<TIntHashSet>> map = this.makeMap();
            TIntObjectIterator<TIntObjectHashMap<TIntHashSet>> it = map.iterator();
            while (it.hasNext()) {
                it.advance();
                int i = it.key();
                TIntObjectHashMap<TIntHashSet> ot = map.get(i);
                TIntObjectIterator<TIntHashSet> it2 = ot.iterator();
                while (it2.hasNext()) {
                    it2.advance();
                    int j = it2.key();
                    TIntHashSet smb = ot.get(j);
                    String s = "";
                    TIntIterator it3 = smb.iterator();
                    while (it3.hasNext()) {
                        s = s + it3.next() + ",";
                    }
                    s = s.substring(0, s.length() - 1);
                    bw.write("   " + i + " -> " + j + "  [ label = \"{" + s + "}\" ];");
                    bw.newLine();
                }
            }
            bw.write("}");
            bw.newLine();
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        int delta = 0;
        for (int i = 0; i < 65535; ++i) {
            while ((char)(i + delta) == '\"' || (char)(i + delta) == '{' || (char)(i + delta) == '}' || (char)(i + delta) == '<' || (char)(i + delta) == '>' || (char)(i + delta) == '[' || (char)(i + delta) == ']' || (char)(i + delta) == '(' || (char)(i + delta) == ')') {
                ++delta;
            }
            charFromIntMap.put(i, i + delta);
            intFromCharMap.put(i + delta, i);
        }
    }
}

