/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints.automaton;

import choco.kernel.common.util.UtilAlgo;
import choco.kernel.model.constraints.automaton.FA.Automaton;
import choco.kernel.model.constraints.automaton.LayeredDFA;
import choco.kernel.model.constraints.automaton.LightLayeredDFA;
import choco.kernel.model.constraints.automaton.State;
import choco.kernel.model.constraints.automaton.Transition;
import choco.kernel.solver.SolverException;
import dk.brics.automaton.RegExp;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DFA {
    protected Transition[] automaton;
    protected int nbState;
    protected List<Integer> finalStates;
    protected int sizeword;
    protected LayeredDFA graph;
    public LightLayeredDFA lightGraph;
    private int[] idxStates;

    public DFA(List<int[]> tuples) {
        this.graph = new LayeredDFA(0, tuples.get(0).length + 1);
        this.setFeasibleOffsets(tuples);
        this.graph.clearAutomate();
        for (int[] tuple : tuples) {
            this.graph.union(tuple);
        }
        this.lightGraph = new LightLayeredDFA(this.graph);
    }

    public DFA(List<int[]> tuples, int[] min, int[] max) {
        this.graph = new LayeredDFA(0, tuples.get(0).length + 1);
        for (int i = 0; i < min.length; ++i) {
            this.graph.setDomSize(i, max[i] - min[i] + 1);
            this.graph.setOffset(i, min[i]);
        }
        this.graph.automatAll();
        for (int[] tuple : tuples) {
            this.graph.substract(tuple);
        }
        this.lightGraph = new LightLayeredDFA(this.graph);
    }

    public DFA(List<Transition> trans, List<Integer> finalStates, int sizeword) {
        this.automaton = new Transition[trans.size()];
        trans.toArray(this.automaton);
        Arrays.sort(this.automaton, new TransitionComparator());
        this.finalStates = finalStates;
        this.sizeword = sizeword;
        this.initializeNbState();
        this.initializeSpeedUpData();
        this.graph = new LayeredDFA(0, sizeword + 1);
        this.graph.clearAutomate();
        this.computeOffsetsAndDomains(sizeword);
        this.buildLayeredGraph(sizeword);
        this.lightGraph = new LightLayeredDFA(this.graph);
    }

    public DFA(String strRegExp, int sizeword) {
        try {
            String formated = UtilAlgo.toCharExp(strRegExp);
            RegExp regexp = new RegExp(formated);
            dk.brics.automaton.Automaton a = regexp.toAutomaton();
            LinkedList<Transition> ts = new LinkedList<Transition>();
            LinkedList<Integer> fs = new LinkedList<Integer>();
            int nbStates = 0;
            Hashtable<dk.brics.automaton.State, Integer> ct = new Hashtable<dk.brics.automaton.State, Integer>();
            ct.put(a.getInitialState(), nbStates++);
            Set states = a.getStates();
            for (dk.brics.automaton.State s : states) {
                if (!ct.containsKey(s)) {
                    ct.put(s, nbStates++);
                }
                if (s.isAccept()) {
                    fs.add((Integer)ct.get(s));
                }
                for (dk.brics.automaton.Transition t : s.getTransitions()) {
                    for (int i = t.getMin(); i <= t.getMax(); ++i) {
                        if (!ct.containsKey(t.getDest())) {
                            ct.put(t.getDest(), nbStates++);
                        }
                        int k = Automaton.getIntFromChar(i);
                        ts.add(new Transition((Integer)ct.get(s), k, (Integer)ct.get(t.getDest())));
                    }
                }
            }
            this.automaton = new Transition[ts.size()];
            ts.toArray(this.automaton);
            Arrays.sort(this.automaton, new TransitionComparator());
            this.finalStates = fs;
            this.sizeword = sizeword;
            this.initializeNbState();
            this.initializeSpeedUpData();
            this.graph = new LayeredDFA(0, sizeword + 1);
            this.graph.buildAnEmptyAutomaton();
            this.computeOffsetsAndDomains(sizeword);
            this.buildLayeredGraph(sizeword);
            this.lightGraph = new LightLayeredDFA(this.graph);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SolverException("Regular expression requires the package automaton.jar that you can download on http://www.brics.dk/automaton/");
        }
    }

    public LayeredDFA getGraph() {
        return this.graph;
    }

    public void setGraph(LayeredDFA graph) {
        this.graph = graph;
    }

    public LightLayeredDFA getLightGraph() {
        return this.lightGraph;
    }

    public void setLightGraph(LightLayeredDFA lightGraph) {
        this.lightGraph = lightGraph;
    }

    private boolean isFinal(int i) {
        return this.finalStates.contains(i);
    }

    private void initializeNbState() {
        BitSet b = new BitSet();
        for (int i = 0; i < this.automaton.length; ++i) {
            if (!b.get(this.automaton[i].origin)) {
                b.set(this.automaton[i].origin);
                ++this.nbState;
            }
            if (b.get(this.automaton[i].destination)) continue;
            b.set(this.automaton[i].destination);
            ++this.nbState;
        }
    }

    private void initializeSpeedUpData() {
        int lastState = -1;
        this.idxStates = new int[this.nbState];
        for (int i = 0; i < this.automaton.length; ++i) {
            if (lastState != this.automaton[i].origin) {
                this.idxStates[this.automaton[i].origin] = i;
            }
            lastState = this.automaton[i].origin;
        }
    }

    public List<Transition> getOutEdges(int s) {
        LinkedList<Transition> outEdges = new LinkedList<Transition>();
        for (int cpt = this.idxStates[s]; cpt < this.automaton.length && this.automaton[cpt].origin == s; ++cpt) {
            outEdges.add(this.automaton[cpt]);
        }
        return outEdges;
    }

    private void computeOffsets(int layer, Enumeration<Integer> stateLi) {
        int minValue = Integer.MAX_VALUE;
        int maxValue = Integer.MIN_VALUE;
        while (stateLi.hasMoreElements()) {
            int o_state = stateLi.nextElement();
            List<Transition> outedges = this.getOutEdges(o_state);
            for (Transition t : outedges) {
                if (t.value < minValue) {
                    minValue = t.value;
                }
                if (t.value <= maxValue) continue;
                maxValue = t.value;
            }
        }
        this.graph.setDomSize(layer, maxValue - minValue + 1);
        this.graph.setOffset(layer, minValue);
    }

    private void computeInitOffsets() {
        int minValue = Integer.MAX_VALUE;
        int maxValue = Integer.MIN_VALUE;
        List<Transition> outedges = this.getOutEdges(0);
        for (Transition t : outedges) {
            if (t.value < minValue) {
                minValue = t.value;
            }
            if (t.value <= maxValue) continue;
            maxValue = t.value;
        }
        this.graph.setDomSize(0, maxValue - minValue + 1);
        this.graph.setOffset(0, minValue);
    }

    private void computeOffsetsAndDomains(int nbvar) {
        Set<Integer> states = new HashSet<Integer>();
        states.add(0);
        int layer = 0;
        while (states.size() != 0 && layer < nbvar) {
            states = this.computeOffsetAndDomain(layer++, states);
        }
    }

    private Set<Integer> computeOffsetAndDomain(int layer, Set<Integer> stateLi) {
        HashSet<Integer> states = new HashSet<Integer>();
        int minValue = Integer.MAX_VALUE;
        int maxValue = Integer.MIN_VALUE;
        for (int o_state : stateLi) {
            List<Transition> outedges = this.getOutEdges(o_state);
            for (Transition t : outedges) {
                if (t.value < minValue) {
                    minValue = t.value;
                }
                if (t.value > maxValue) {
                    maxValue = t.value;
                }
                states.add(t.destination);
            }
        }
        this.graph.setDomSize(layer, maxValue - minValue + 1);
        this.graph.setOffset(layer, minValue);
        return states;
    }

    protected void buildLayeredGraph(int nbvar) {
        Hashtable[] N = new Hashtable[nbvar + 1];
        this.computeInitOffsets();
        State initState = this.graph.makeState(this.graph, 0);
        State finalState = this.graph.makeState(this.graph, nbvar);
        this.graph.setInitState(initState);
        this.graph.setLastState(finalState);
        for (int i = 0; i <= nbvar; ++i) {
            N[i] = new Hashtable();
        }
        N[0].put(0, initState);
        this.forwardPhase(N, nbvar);
        this.graph.removeUnreachablesNodes();
        this.graph.removeGarbageNodes();
    }

    protected void forwardPhase(Hashtable<Integer, State>[] N, int nbvar) {
        for (int i = 0; i < nbvar; ++i) {
            Enumeration<Integer> stateLi = N[i].keys();
            while (stateLi.hasMoreElements()) {
                int o_state = stateLi.nextElement();
                List<Transition> outedges = this.getOutEdges(o_state);
                State curState = N[i].get(o_state);
                for (Transition t : outedges) {
                    int o_nextstate = t.destination;
                    if (i < nbvar - 1) {
                        State nextState = N[i + 1].get(o_nextstate);
                        if (nextState == null) {
                            nextState = this.graph.makeState(this.graph, i + 1);
                            N[i + 1].put(o_nextstate, nextState);
                        }
                        this.graph.addTransition(curState, nextState, t.value - this.graph.getOffset(i));
                        continue;
                    }
                    if (!this.isFinal(o_nextstate)) continue;
                    this.graph.addTransition(curState, this.graph.getLastState(), t.value - this.graph.getOffset(i));
                }
            }
        }
    }

    private void setFeasibleOffsets(List<int[]> tuples) {
        int tsize = tuples.get(0).length;
        int[] min = new int[tsize];
        int[] max = new int[tsize];
        for (int i = 0; i < tsize; ++i) {
            min[i] = Integer.MAX_VALUE;
            max[i] = Integer.MIN_VALUE;
        }
        for (int[] tuple : tuples) {
            for (int i = 0; i < tsize; ++i) {
                if (tuple[i] < min[i]) {
                    min[i] = tuple[i];
                }
                if (tuple[i] <= max[i]) continue;
                max[i] = tuple[i];
            }
        }
        for (int i = 0; i < tsize; ++i) {
            this.graph.setDomSize(i, max[i] - min[i] + 1);
            this.graph.setOffset(i, min[i]);
        }
    }

    class TransitionComparator
    implements Comparator {
        TransitionComparator() {
        }

        public int compare(Object o1, Object o2) {
            int c1 = ((Transition)o1).origin;
            int c2 = ((Transition)o2).origin;
            if (c1 < c2) {
                return -1;
            }
            if (c1 == c2) {
                int c1bis = ((Transition)o1).value;
                int c2bis = ((Transition)o2).value;
                if (c1bis < c2bis) {
                    return -1;
                }
                if (c1bis == c2bis) {
                    return 0;
                }
                return 1;
            }
            return 1;
        }
    }
}

