/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints;

import choco.kernel.common.util.ChocoUtil;
import choco.kernel.common.util.UtilAlgo;
import choco.kernel.model.constraints.AbstractConstraint;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.variables.Variable;
import java.util.Iterator;
import java.util.Properties;

public class MetaConstraint<E extends Constraint>
extends AbstractConstraint {
    protected E[] constraints;

    public MetaConstraint(ConstraintType type, E ... constraints) {
        super(type);
        this.constraints = constraints;
    }

    public MetaConstraint(Class metaManager, E ... constraints) {
        super(metaManager.getName());
        this.constraints = constraints;
    }

    public MetaConstraint(String metaManager, E ... constraints) {
        super(metaManager);
        this.constraints = constraints;
    }

    public E[] getConstraints() {
        return this.constraints;
    }

    public final E getConstraint(int idx) {
        return this.constraints[idx];
    }

    @Override
    public Iterator<Variable> getVariableIterator() {
        return ChocoUtil.iterator(this.extractVariables());
    }

    @Override
    public int getNbVars() {
        return 0;
    }

    @Override
    public Variable[] extractVariables() {
        Variable[] listVars = new Variable[]{};
        for (E c : this.constraints) {
            listVars = UtilAlgo.append(listVars, c.extractVariables());
        }
        return ChocoUtil.getNonRedundantObjects(Variable.class, listVars);
    }

    @Override
    public void findManager(Properties propertiesFile) {
        super.findManager(propertiesFile);
        for (int i = 0; i < this.constraints.length; ++i) {
            E constraint = this.constraints[i];
            constraint.findManager(propertiesFile);
        }
    }
}

