/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints;

import choco.kernel.common.util.ChocoUtil;
import choco.kernel.common.util.UtilAlgo;
import choco.kernel.model.constraints.ComponentConstraint;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.variables.Variable;
import java.util.ArrayList;
import java.util.Properties;

public class ComponentConstraintWithSubConstraints
extends ComponentConstraint {
    private final ArrayList<Constraint> constraints;
    private final ArrayList<Variable> listVars;

    public ComponentConstraintWithSubConstraints(ConstraintType constraintType, Variable[] variables, Object params, Constraint ... constraints) {
        super(constraintType, params, variables);
        this.constraints = UtilAlgo.toList(constraints);
        this.listVars = new ArrayList<Variable>(UtilAlgo.toList(variables));
    }

    public ComponentConstraintWithSubConstraints(String componentClassName, Variable[] variables, Object params, Constraint ... constraints) {
        super(componentClassName, ComponentConstraintWithSubConstraints.appendParameters(params, constraints), variables);
        this.constraints = UtilAlgo.toList(constraints);
        this.listVars = new ArrayList<Variable>(UtilAlgo.toList(variables));
    }

    public ComponentConstraintWithSubConstraints(Class componentClass, Variable[] variables, Object params, Constraint ... constraints) {
        super(componentClass, ComponentConstraintWithSubConstraints.appendParameters(params, constraints), variables);
        this.constraints = UtilAlgo.toList(constraints);
        this.listVars = new ArrayList<Variable>(UtilAlgo.toList(variables));
    }

    public <V extends Variable> void addElements(V[] vars, Constraint[] cstrs) {
        this.recordIndexes((Variable[])vars);
        this.constraints.addAll(UtilAlgo.toList(cstrs));
    }

    private <V extends Variable> void recordIndexes(V[] vars) {
        for (int i = 0; i < vars.length; ++i) {
            if (this.listVars.contains(vars[i])) continue;
            this.listVars.add((Variable)vars[i]);
            this.variables = UtilAlgo.append(this.variables, {vars[i]});
        }
    }

    @Override
    public Variable[] getVariables() {
        return UtilAlgo.toArray(Variable.class, this.listVars);
    }

    @Override
    public int getNbVars() {
        return this.listVars.size();
    }

    @Override
    public Object getParameters() {
        return ComponentConstraintWithSubConstraints.appendParameters(this.parameters, UtilAlgo.toArray(Constraint.class, this.constraints));
    }

    private static final Object appendParameters(Object parameters, Constraint ... constraints) {
        return new Object[]{parameters, constraints};
    }

    @Override
    public final void findManager(Properties propertiesFile) {
        super.findManager(propertiesFile);
        for (int i = 0; i < this.constraints.size(); ++i) {
            Constraint constraint = this.constraints.get(i);
            constraint.findManager(propertiesFile);
        }
    }

    @Override
    public Variable[] extractVariables() {
        Variable[] listVars = this.getVariables();
        for (Constraint c : this.constraints) {
            listVars = UtilAlgo.append(listVars, c.extractVariables());
        }
        return ChocoUtil.getNonRedundantObjects(Variable.class, listVars);
    }
}

