/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints;

import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.AbstractConstraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.variables.Variable;
import java.util.Iterator;

public class BinaryConstraint<E extends Variable>
extends AbstractConstraint {
    protected E v1;
    protected E v2;

    public BinaryConstraint(ConstraintType type, E v1, E v2) {
        super(type);
        this.v1 = v1;
        this.v2 = v2;
    }

    @Override
    public int getNbVars() {
        return 2;
    }

    @Override
    public Iterator<Variable> getVariableIterator() {
        return new Iterator<Variable>(){
            int i = -1;

            @Override
            public boolean hasNext() {
                return this.i < 2;
            }

            @Override
            public Variable next() {
                return this.i++ == 1 ? BinaryConstraint.this.v1 : BinaryConstraint.this.v2;
            }

            @Override
            public void remove() {
                throw new ModelException("can not remove variable from binary constraint");
            }
        };
    }

    public E getV1() {
        return this.v1;
    }

    public E getV2() {
        return this.v2;
    }
}

