/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints;

import choco.kernel.common.HashCoding;
import choco.kernel.common.util.ChocoUtil;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintManager;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.constraints.ExpressionManager;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;

public abstract class AbstractConstraint
implements Constraint,
Comparable {
    protected ConstraintType type;
    protected HashSet<String> options = new HashSet();
    private TIntArrayList modelIndexes;
    private TIntIntHashMap indexes;
    protected String manager;
    protected ConstraintManager cm;
    protected ExpressionManager em;

    public AbstractConstraint(ConstraintType type) {
        this.type = type;
        this.modelIndexes = new TIntArrayList();
        this.indexes = new TIntIntHashMap();
    }

    public AbstractConstraint(String consMan) {
        this.type = ConstraintType.NONE;
        this.manager = consMan;
        this.modelIndexes = new TIntArrayList();
        this.indexes = new TIntIntHashMap();
    }

    @Override
    public HashSet<String> getOptions() {
        return this.options;
    }

    public int hashCode() {
        return HashCoding.hashCodeMe(new Object[]{this.indexes});
    }

    @Override
    public int getIndexIn(int masterIndex) {
        if (this.indexes.containsKey(masterIndex)) {
            return this.indexes.get(masterIndex);
        }
        return -1;
    }

    @Override
    public void setIndexIn(int masterInd, int ind) {
        this.indexes.put(masterInd, ind);
    }

    @Override
    public void addOption(String opts) {
        if (opts != null && !"".equals(opts)) {
            String[] optionsStrings = opts.split(" ");
            for (int j = 0; j < optionsStrings.length; ++j) {
                String optionsString = optionsStrings[j];
                this.options.add(optionsString);
            }
        }
    }

    @Override
    public void addOptions(String[] options) {
        for (int o = 0; o < options.length; ++o) {
            this.addOption(options[o]);
        }
    }

    @Override
    public void addOptions(HashSet<String> options) {
        if (options != null) {
            while (options.iterator().hasNext()) {
                String opt = options.iterator().next();
                this.addOption(opt);
            }
        }
    }

    @Override
    public Variable[] getVariables() {
        return null;
    }

    protected void variablesPrettyPrint(StringBuilder buffer) {
        buffer.append(ChocoUtil.pretty(this.getVariableIterator()));
    }

    @Override
    public String pretty() {
        StringBuilder st = new StringBuilder("Constraint ");
        st.append(this.type.name).append(" ( ");
        this.variablesPrettyPrint(st);
        st.append(" )");
        return st.toString();
    }

    @Override
    public final ConstraintType getConstraintType() {
        return this.type;
    }

    @Override
    public final void setType(ConstraintType type) {
        this.type = type;
    }

    public IntegerVariable[] getIntVariableScope() {
        Iterator<Variable> itvs = this.getVariableIterator();
        HashSet<IntegerVariable> vs = new HashSet<IntegerVariable>();
        while (itvs.hasNext()) {
            Variable v1 = itvs.next();
            if (v1.getVariableType() == VariableType.INTEGER && !vs.contains(v1)) {
                vs.add((IntegerVariable)v1);
                continue;
            }
            if (!v1.getVariableType().equals((Object)VariableType.INTEGER_EXPRESSION)) continue;
            HashSet<Variable> tmp = this.extractEveryvariables((IntegerExpressionVariable)v1);
            for (Variable v : tmp) {
                if (v.getVariableType() != VariableType.INTEGER || vs.contains(v)) continue;
                vs.add((IntegerVariable)v);
            }
        }
        IntegerVariable[] vars = new IntegerVariable[vs.size()];
        int cpt = 0;
        Iterator iterator = vs.iterator();
        while (iterator.hasNext()) {
            vars[cpt++] = (IntegerVariable)iterator.next();
        }
        return vars;
    }

    private HashSet<Variable> extractEveryvariables(IntegerExpressionVariable iev) {
        HashSet<Variable> vs = new HashSet<Variable>();
        if (iev.getVariableType().equals((Object)VariableType.INTEGER)) {
            if (!vs.contains(iev)) {
                vs.add(iev);
            }
        } else if (iev.getVariableType().equals((Object)VariableType.INTEGER_EXPRESSION)) {
            Variable[] tmp = iev.extractVariables();
            Iterator<Variable> it = ChocoUtil.iterator(tmp);
            while (it.hasNext()) {
                vs.addAll(this.extractEveryvariables((IntegerExpressionVariable)it.next()));
            }
        }
        return vs;
    }

    @Override
    public int[] getFavoriteDomains() {
        return new int[]{0, 2, 4, 3, 1};
    }

    @Override
    public Variable[] extractVariables() {
        Variable[] listVars = null;
        if (this.getVariables() != null) {
            listVars = ChocoUtil.getNonRedundantObjects(Variable.class, this.getVariables());
        }
        return listVars;
    }

    public ConstraintManager getCm() {
        if (this.cm == null) {
            this.cm = (ConstraintManager)this.loadManager(this.getManager());
        }
        return this.cm;
    }

    @Override
    public ExpressionManager getEm() {
        if (this.em == null) {
            this.em = (ExpressionManager)this.loadManager(this.getManager());
        }
        return this.em;
    }

    public String getManager() {
        return this.manager;
    }

    @Override
    public void findManager(Properties propertiesFile) {
        if (this.manager == null) {
            if (this.type.property == null) {
                throw new ModelException("Empty property, can not read it!");
            }
            this.manager = propertiesFile.getProperty(this.type.property);
            if (this.manager == null) {
                throw new ModelException("No property found for " + this.type.property + " in application.properties");
            }
        }
    }

    public Object loadManager(String manager) {
        Class<?> componentClass = null;
        try {
            componentClass = Class.forName(manager);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Component class could not be found: " + manager);
            System.exit(-1);
        }
        try {
            return componentClass.newInstance();
        }
        catch (InstantiationException e) {
            System.err.println("Component class could not be instantiated: " + manager);
            System.exit(-1);
        }
        catch (IllegalAccessException e) {
            System.err.println("Component class could not be accessed: " + manager);
            System.exit(-1);
        }
        return null;
    }

    @Override
    public void addedTo(int modelIndex) {
        this.modelIndexes.add(modelIndex);
    }

    @Override
    public void removedFrom(int modelIndex) {
        int ind = this.modelIndexes.indexOf(modelIndex);
        if (ind > -1) {
            this.modelIndexes.remove(ind);
        }
    }

    @Override
    public Boolean alreadyIn(int modelIndex) {
        return this.modelIndexes.contains(modelIndex);
    }

    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        return 1;
    }
}

