/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing;

import choco.kernel.memory.IStateLong;
import choco.kernel.memory.trailing.AbstractStoredObject;
import choco.kernel.memory.trailing.EnvironmentTrailing;
import choco.kernel.memory.trailing.StoredLongTrail;

public final class StoredLong
extends AbstractStoredObject
implements IStateLong {
    private long currentValue;
    private final StoredLongTrail trail;

    public StoredLong(EnvironmentTrailing env) {
        this(env, 0L);
    }

    public StoredLong(EnvironmentTrailing env, long d) {
        super(env);
        this.currentValue = d;
        this.trail = (StoredLongTrail)this.environment.getTrail(5);
    }

    @Override
    public long get() {
        return this.currentValue;
    }

    @Override
    public void set(long y) {
        if (y != this.currentValue) {
            if (this.worldStamp < this.environment.getWorldIndex()) {
                this.trail.savePreviousState(this, this.currentValue, this.worldStamp);
                this.worldStamp = this.environment.getWorldIndex();
            }
            this.currentValue = y;
        }
    }

    @Override
    public void add(long delta) {
        this.set(this.currentValue + delta);
    }

    void _set(long y, int wstamp) {
        this.currentValue = y;
        this.worldStamp = wstamp;
    }

    public String toString() {
        return String.valueOf(this.currentValue);
    }
}

