/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing;

import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.solver.SolverException;

public class StoredIntBipartiteList
implements IStateIntVector {
    protected int[] list;
    protected IStateInt last;
    protected DisposableIntIterator lastIterator;

    public StoredIntBipartiteList(IEnvironment environment, int[] values) {
        this.list = values;
        this.last = environment.makeInt(values.length - 1);
    }

    @Override
    public int size() {
        return this.last.get() + 1;
    }

    @Override
    public boolean isEmpty() {
        return this.last.get() == -1;
    }

    @Override
    public void add(int i) {
        throw new UnsupportedOperationException("adding element is not permitted in this structure (the list is only meant to decrease during search)");
    }

    @Override
    public void remove(int i) {
        throw new UnsupportedOperationException("removing element is not permitted in this structure (the list is only meant to decrease during search)");
    }

    @Override
    public void removeLast() {
        this.last.add(-1);
    }

    @Override
    public int get(int index) {
        return this.list[index];
    }

    @Override
    public int set(int index, int val) {
        throw new SolverException("setting an element is not permitted on this structure");
    }

    @Override
    public DisposableIntIterator getIterator() {
        BipartiteListIterator iter = (BipartiteListIterator)this.lastIterator;
        if (iter != null && iter.disposed) {
            iter.init();
            return iter;
        }
        this.lastIterator = new BipartiteListIterator();
        return this.lastIterator;
    }

    public String pretty() {
        String s = "[";
        for (int i = 0; i <= this.last.get(); ++i) {
            s = s + this.list[i] + (i == this.last.get() ? "" : ",");
        }
        return s + "]";
    }

    private class BipartiteListIterator
    extends DisposableIntIterator {
        int idx;
        boolean disposed;

        public BipartiteListIterator() {
            this.init();
        }

        @Override
        public void init() {
            this.idx = 0;
            this.disposed = false;
        }

        @Override
        public boolean hasNext() {
            return this.idx <= StoredIntBipartiteList.this.last.get();
        }

        @Override
        public int next() {
            return StoredIntBipartiteList.this.list[this.idx++];
        }

        @Override
        public void remove() {
            --this.idx;
            int temp = StoredIntBipartiteList.this.list[StoredIntBipartiteList.this.last.get()];
            StoredIntBipartiteList.this.list[StoredIntBipartiteList.this.last.get()] = StoredIntBipartiteList.this.list[this.idx];
            StoredIntBipartiteList.this.list[this.idx] = temp;
            StoredIntBipartiteList.this.last.add(-1);
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }
    }
}

