/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing;

import choco.kernel.memory.IStateInt;
import choco.kernel.memory.trailing.AbstractStoredObject;
import choco.kernel.memory.trailing.EnvironmentTrailing;
import choco.kernel.memory.trailing.StoredIntTrail;

public class StoredInt
extends AbstractStoredObject
implements IStateInt {
    private int currentValue;
    private final StoredIntTrail trail;

    public StoredInt(EnvironmentTrailing env, int i) {
        super(env);
        this.currentValue = i;
        this.trail = (StoredIntTrail)this.environment.getTrail(1);
    }

    @Override
    public final void add(int delta) {
        this.set(this.currentValue + delta);
    }

    @Override
    public final int get() {
        return this.currentValue;
    }

    @Override
    public final void set(int y) {
        if (y != this.currentValue) {
            if (this.worldStamp < this.environment.getWorldIndex()) {
                this.trail.savePreviousState(this, this.currentValue, this.worldStamp);
                this.worldStamp = this.environment.getWorldIndex();
            }
            this.currentValue = y;
        }
    }

    protected void _set(int y, int wstamp) {
        this.currentValue = y;
        this.worldStamp = wstamp;
    }

    public final String toString() {
        return String.valueOf(this.currentValue);
    }
}

