/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing;

import choco.kernel.memory.IStateDouble;
import choco.kernel.memory.trailing.AbstractStoredObject;
import choco.kernel.memory.trailing.EnvironmentTrailing;
import choco.kernel.memory.trailing.StoredDoubleTrail;

public final class StoredDouble
extends AbstractStoredObject
implements IStateDouble {
    private double currentValue;
    private final StoredDoubleTrail trail;

    public StoredDouble(EnvironmentTrailing env, double d) {
        super(env);
        this.currentValue = d;
        this.worldStamp = env.getWorldIndex();
        this.trail = (StoredDoubleTrail)this.environment.getTrail(4);
    }

    @Override
    public double get() {
        return this.currentValue;
    }

    @Override
    public void set(double y) {
        if (y != this.currentValue) {
            if (this.worldStamp < this.environment.getWorldIndex()) {
                this.trail.savePreviousState(this, this.currentValue, this.worldStamp);
                this.worldStamp = this.environment.getWorldIndex();
            }
            this.currentValue = y;
        }
    }

    @Override
    public void add(double delta) {
        this.set(this.get() + delta);
    }

    void _set(double y, int wstamp) {
        this.currentValue = y;
        this.worldStamp = wstamp;
    }

    public String toString() {
        return String.valueOf(this.currentValue);
    }
}

