/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing;

import choco.kernel.common.util.IntIterator;
import choco.kernel.common.util.OpenBitSet;
import choco.kernel.memory.AbstractStateBitSet;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.IStateLong;
import choco.kernel.memory.trailing.EnvironmentTrailing;
import choco.kernel.memory.trailing.StoredLong;
import java.lang.reflect.Array;
import java.util.BitSet;

public class StoredBitSet
extends AbstractStateBitSet {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final long WORD_MASK = -1L;
    private final IEnvironment environment;
    private IStateLong[] words;
    private IStateInt wordsInUse;

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private void recalculateWordsInUse() {
        int i;
        for (i = this.wordsInUse.get() - 1; i >= 0 && this.words[i].get() == 0L; --i) {
        }
        this.wordsInUse.set(i + 1);
    }

    public StoredBitSet(IEnvironment environment) {
        this.environment = environment;
        this.wordsInUse = environment.makeInt(0);
        this.initWords(64);
    }

    public StoredBitSet(IEnvironment environment, int nbits) {
        this.environment = environment;
        this.wordsInUse = environment.makeInt(0);
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        this.initWords(nbits);
    }

    private void initWords(int nbits) {
        this.words = new StoredLong[StoredBitSet.wordIndex(nbits - 1) + 1];
        for (int i = 0; i < this.words.length; ++i) {
            this.words[i] = new StoredLong((EnvironmentTrailing)this.environment);
        }
    }

    @Override
    public void ensureCapacity(int wordsRequired) {
        if (this.words.length < wordsRequired) {
            int request = Math.max(2 * this.words.length, wordsRequired);
            int oldSize = this.words.length;
            this.words = StoredBitSet.copyOf(this.words, request);
            for (int i = oldSize; i < request; ++i) {
                this.words[i] = this.environment.makeLong(0);
            }
        }
    }

    @Override
    public IntIterator getCycleButIterator(int avoidIndex) {
        int n = this.cardinality();
        if (avoidIndex != -1 && this.get(avoidIndex)) {
            --n;
        }
        if (n > 0) {
            return new IStateBitSet.CyclicIterator(this, avoidIndex);
        }
        return new IStateBitSet.EmptyIterator();
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return StoredBitSet.copyOf(original, newLength, original.getClass());
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public BitSet copyToBitSet() {
        BitSet view = new BitSet(this.size());
        int i = this.nextSetBit(0);
        while (i >= 0) {
            view.set(i, true);
            i = this.nextSetBit(i + 1);
        }
        return view;
    }

    private void expandTo(int wordIndex) {
        int wordsRequired = wordIndex + 1;
        if (this.wordsInUse.get() < wordsRequired) {
            this.ensureCapacity(wordsRequired);
            this.wordsInUse.set(wordsRequired);
        }
    }

    private static void checkRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
    }

    @Override
    public void flip(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = StoredBitSet.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        long tmp = this.words[wordIndex].get();
        this.words[wordIndex].set(tmp ^= 1L << bitIndex);
        this.recalculateWordsInUse();
    }

    @Override
    public void flip(int fromIndex, int toIndex) {
        StoredBitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = StoredBitSet.wordIndex(fromIndex);
        int endWordIndex = StoredBitSet.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            long tmp = this.words[startWordIndex].get();
            this.words[startWordIndex].set(tmp ^= firstWordMask & lastWordMask);
        } else {
            this.words[startWordIndex].set(this.words[startWordIndex].get() ^ firstWordMask);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i].set(this.words[i].get() ^ 0xFFFFFFFFFFFFFFFFL);
            }
            this.words[endWordIndex].set(this.words[endWordIndex].get() ^ lastWordMask);
        }
        this.recalculateWordsInUse();
    }

    @Override
    public void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = StoredBitSet.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        this.words[wordIndex].set(this.words[wordIndex].get() | 1L << bitIndex);
    }

    @Override
    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    @Override
    public void set(int fromIndex, int toIndex) {
        StoredBitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = StoredBitSet.wordIndex(fromIndex);
        int endWordIndex = StoredBitSet.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.words[startWordIndex].set(this.words[startWordIndex].get() | firstWordMask & lastWordMask);
        } else {
            this.words[startWordIndex].set(this.words[startWordIndex].get() | firstWordMask);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i].set(-1L);
            }
            this.words[endWordIndex].set(this.words[endWordIndex].get() | lastWordMask);
        }
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    @Override
    public void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = StoredBitSet.wordIndex(bitIndex);
        if (wordIndex >= this.wordsInUse.get()) {
            return;
        }
        this.words[wordIndex].set(this.words[wordIndex].get() & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL));
        this.recalculateWordsInUse();
    }

    public void clear(int fromIndex, int toIndex) {
        StoredBitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = StoredBitSet.wordIndex(fromIndex);
        if (startWordIndex >= this.wordsInUse.get()) {
            return;
        }
        int endWordIndex = StoredBitSet.wordIndex(toIndex - 1);
        if (endWordIndex >= this.wordsInUse.get()) {
            toIndex = this.length();
            endWordIndex = this.wordsInUse.get() - 1;
        }
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.words[startWordIndex].set(this.words[startWordIndex].get() & (firstWordMask & lastWordMask ^ 0xFFFFFFFFFFFFFFFFL));
        } else {
            this.words[startWordIndex].set(this.words[startWordIndex].get() & (firstWordMask ^ 0xFFFFFFFFFFFFFFFFL));
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i].set(0L);
            }
            this.words[endWordIndex].set(this.words[endWordIndex].get() & (lastWordMask ^ 0xFFFFFFFFFFFFFFFFL));
        }
        this.recalculateWordsInUse();
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.words.length; ++i) {
            IStateLong word = this.words[i];
            word.set(0L);
        }
    }

    @Override
    public final boolean get(int bitIndex) {
        int wordIndex = bitIndex >> 6;
        return wordIndex < this.wordsInUse.get() && (this.words[wordIndex].get() & 1L << bitIndex) != 0L;
    }

    public StoredBitSet get(int fromIndex, int toIndex) {
        StoredBitSet.checkRange(fromIndex, toIndex);
        int len = this.length();
        if (len <= fromIndex || fromIndex == toIndex) {
            return new StoredBitSet(this.environment, 0);
        }
        if (toIndex > len) {
            toIndex = len;
        }
        StoredBitSet result = new StoredBitSet(this.environment, toIndex - fromIndex);
        int targetWords = StoredBitSet.wordIndex(toIndex - fromIndex - 1) + 1;
        int sourceIndex = StoredBitSet.wordIndex(fromIndex);
        boolean wordAligned = (fromIndex & 0x3F) == 0;
        int i = 0;
        while (i < targetWords - 1) {
            result.words[i].set(wordAligned ? this.words[sourceIndex].get() : this.words[sourceIndex].get() >>> fromIndex | this.words[sourceIndex + 1].get() << -fromIndex);
            ++i;
            ++sourceIndex;
        }
        long lastWordMask = -1L >>> -toIndex;
        result.words[targetWords - 1].set((toIndex - 1 & 0x3F) < (fromIndex & 0x3F) ? this.words[sourceIndex].get() >>> fromIndex | (this.words[sourceIndex + 1].get() & lastWordMask) << -fromIndex : (this.words[sourceIndex].get() & lastWordMask) >>> fromIndex);
        result.wordsInUse.set(targetWords);
        result.recalculateWordsInUse();
        return result;
    }

    @Override
    public int nextSetBit(int fromIndex) {
        int u = StoredBitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse.get()) {
            return -1;
        }
        long word = this.words[u].get() & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.wordsInUse.get()) {
                return -1;
            }
            word = this.words[u].get();
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    @Override
    public int prevSetBit(int fromIndex) {
        int u = StoredBitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse.get()) {
            return this.length() - 1;
        }
        long mask = -1L << fromIndex + 1 ^ 0xFFFFFFFFFFFFFFFFL;
        long word = this.words[u].get() & (mask != 0L ? mask : -1L);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words[u].get();
        }
        return u * 64 + 63 - Long.numberOfLeadingZeros(word);
    }

    public int prevClearBit(int fromIndex) {
        int u = StoredBitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse.get()) {
            return fromIndex;
        }
        long mask = -1L << fromIndex + 1 ^ 0xFFFFFFFFFFFFFFFFL;
        long word = (this.words[u].get() ^ 0xFFFFFFFFFFFFFFFFL) & (mask != 0L ? mask : -1L);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words[u].get() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return u * 64 + 63 - Long.numberOfLeadingZeros(word);
    }

    @Override
    public int capacity() {
        return this.words.length * 64;
    }

    public int nextClearBit(int fromIndex) {
        int u = StoredBitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse.get()) {
            return fromIndex;
        }
        long word = (this.words[u].get() ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.wordsInUse.get()) {
                return this.wordsInUse.get() * 64;
            }
            word = this.words[u].get() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public int length() {
        if (this.wordsInUse.get() == 0) {
            return 0;
        }
        return 64 * (this.wordsInUse.get() - 1) + (64 - Long.numberOfLeadingZeros(this.words[this.wordsInUse.get() - 1].get()));
    }

    @Override
    public boolean isEmpty() {
        return this.wordsInUse.get() == 0;
    }

    public boolean intersects(StoredBitSet set) {
        for (int i = Math.min(this.wordsInUse.get(), set.wordsInUse.get()) - 1; i >= 0; --i) {
            if ((this.words[i].get() & set.words[i].get()) == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(OpenBitSet set) {
        for (int i = Math.min(this.wordsInUse.get(), set.wordsInUse) - 1; i >= 0; --i) {
            if ((this.words[i].get() & set.words[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public int cardinality() {
        int sum = 0;
        for (int i = 0; i < this.wordsInUse.get(); ++i) {
            sum += Long.bitCount(this.words[i].get());
        }
        return sum;
    }

    @Override
    public void and(IStateBitSet setI) {
        StoredBitSet set = (StoredBitSet)setI;
        if (this == set) {
            return;
        }
        while (this.wordsInUse.get() > set.wordsInUse.get()) {
            this.wordsInUse.add(-1);
            this.words[this.wordsInUse.get()].set(0L);
        }
        for (int i = 0; i < this.wordsInUse.get(); ++i) {
            this.words[i].set(this.words[i].get() & set.words[i].get());
        }
        this.recalculateWordsInUse();
    }

    @Override
    public void or(IStateBitSet setI) {
        StoredBitSet set = (StoredBitSet)setI;
        if (this == set) {
            return;
        }
        int wordsInCommon = Math.min(this.wordsInUse.get(), set.wordsInUse.get());
        if (this.wordsInUse.get() < set.wordsInUse.get()) {
            this.ensureCapacity(set.wordsInUse.get());
            this.wordsInUse.set(set.wordsInUse.get());
        }
        for (int i = 0; i < wordsInCommon; ++i) {
            this.words[i].set(this.words[i].get() | set.words[i].get());
        }
        if (wordsInCommon < set.wordsInUse.get()) {
            System.arraycopy(set.words, wordsInCommon, this.words, wordsInCommon, this.wordsInUse.get() - wordsInCommon);
        }
    }

    @Override
    public void xor(IStateBitSet setI) {
        StoredBitSet set = (StoredBitSet)setI;
        int wordsInCommon = Math.min(this.wordsInUse.get(), set.wordsInUse.get());
        if (this.wordsInUse.get() < set.wordsInUse.get()) {
            this.ensureCapacity(set.wordsInUse.get());
            this.wordsInUse.set(set.wordsInUse.get());
        }
        for (int i = 0; i < wordsInCommon; ++i) {
            this.words[i].set(this.words[i].get() ^ set.words[i].get());
        }
        if (wordsInCommon < set.wordsInUse.get()) {
            System.arraycopy(set.words, wordsInCommon, this.words, wordsInCommon, set.wordsInUse.get() - wordsInCommon);
        }
        this.recalculateWordsInUse();
    }

    @Override
    public void andNot(IStateBitSet setI) {
        StoredBitSet set = (StoredBitSet)setI;
        for (int i = Math.min(this.wordsInUse.get(), set.wordsInUse.get()) - 1; i >= 0; --i) {
            this.words[i].set(this.words[i].get() & (set.words[i].get() ^ 0xFFFFFFFFFFFFFFFFL));
        }
        this.recalculateWordsInUse();
    }

    @Override
    public boolean intersects(IStateBitSet setI) {
        StoredBitSet set = (StoredBitSet)setI;
        for (int i = Math.min(this.wordsInUse.get(), set.wordsInUse.get()) - 1; i >= 0; --i) {
            if ((this.words[i].get() & set.words[i].get()) == 0L) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        long h = 1234L;
        int i = this.wordsInUse.get();
        while (--i >= 0) {
            h ^= this.words[i].get() * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    @Override
    public int size() {
        return this.words.length * 64;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StoredBitSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        StoredBitSet set = (StoredBitSet)obj;
        if (this.wordsInUse != set.wordsInUse) {
            return false;
        }
        for (int i = 0; i < this.wordsInUse.get(); ++i) {
            if (this.words[i] == set.words[i]) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        StoredBitSet result = new StoredBitSet(this.environment, this.size());
        result.wordsInUse.set(this.wordsInUse.get());
        for (int i = 0; i < this.wordsInUse.get(); ++i) {
            result.words[i].set(this.words[i].get());
        }
        return result;
    }

    private void trimToSize() {
        if (this.wordsInUse.get() != this.words.length) {
            this.words = StoredBitSet.copyOf(this.words, this.wordsInUse.get());
        }
    }

    public String toString() {
        int numBits = this.wordsInUse.get() > 128 ? this.cardinality() : this.wordsInUse.get() * 64;
        StringBuilder b = new StringBuilder(6 * numBits + 2);
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            i = this.nextSetBit(i + 1);
            while (i >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i < endOfRun);
                i = this.nextSetBit(i + 1);
            }
        }
        b.append('}');
        return b.toString();
    }
}

