/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing;

import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public final class StoredBipartiteList<E>
extends AbstractList<E> {
    protected E[] elementData;
    protected IStateInt last;

    public StoredBipartiteList(IEnvironment env, Collection<E> coll) {
        this.elementData = coll.toArray();
        this.last = env.makeInt(this.elementData.length);
    }

    public StoredBipartiteList(IEnvironment env, E[] elementData) {
        this.elementData = Arrays.copyOf(elementData, elementData.length);
        this.last = env.makeInt(elementData.length);
    }

    private void RangeCheck(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
    }

    @Override
    public E get(int index) {
        this.RangeCheck(index);
        return this.elementData[index];
    }

    public E getQuick(int index) {
        return this.elementData[index];
    }

    public Iterator<E> quickIterator() {
        return new QuickItr();
    }

    @Override
    public int size() {
        return this.last.get();
    }

    @Override
    public E remove(int index) {
        this.RangeCheck(index);
        int idx = this.size() - 1;
        E tmp = this.elementData[index];
        this.elementData[index] = this.elementData[idx];
        this.elementData[idx] = tmp;
        this.last.set(idx);
        return tmp;
    }

    @Override
    public void sort(Comparator<E> cmp) {
        Arrays.sort(this.elementData, 0, this.size(), cmp);
    }

    private class QuickItr
    implements Iterator<E> {
        int cursor = 0;

        private QuickItr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != StoredBipartiteList.this.size();
        }

        @Override
        public E next() {
            return StoredBipartiteList.this.elementData[this.cursor++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cant remove with quick iterator.");
        }
    }
}

