/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing;

import choco.kernel.memory.IStateBinaryTree;
import choco.kernel.memory.trailing.EnvironmentTrailing;
import choco.kernel.memory.trailing.ITrailStorage;

public class StoredBinaryTreeTrail
implements ITrailStorage {
    private IStateBinaryTree[] treeStack;
    private IStateBinaryTree.Node[] nodeStack;
    private int[] opStack;
    private int[] oldValues;
    private int[] stampStack;
    private int[] worldStartLevels;
    private EnvironmentTrailing environment;
    private int maxHist;
    private int currentLevel;

    public StoredBinaryTreeTrail(EnvironmentTrailing env, int maxHist, int maxWorld) {
        this.environment = env;
        this.currentLevel = 0;
        this.opStack = new int[maxHist];
        this.oldValues = new int[maxHist];
        this.treeStack = new IStateBinaryTree[maxHist];
        this.nodeStack = new IStateBinaryTree.Node[maxHist];
        this.stampStack = new int[maxHist];
        this.worldStartLevels = new int[maxWorld];
        this.maxHist = maxHist;
    }

    public void stack(IStateBinaryTree b, IStateBinaryTree.Node n, int operation) {
        this.treeStack[this.currentLevel] = b;
        this.nodeStack[this.currentLevel] = n;
        this.opStack[this.currentLevel] = operation;
        switch (operation) {
            case 0: {
                this.oldValues[this.currentLevel] = n.inf;
                this.stampStack[this.currentLevel] = n.infStamp;
                break;
            }
            case 1: {
                this.oldValues[this.currentLevel] = n.sup;
                this.stampStack[this.currentLevel] = n.supStamp;
                break;
            }
        }
        ++this.currentLevel;
        if (this.currentLevel == this.maxHist) {
            this.resizeUpdateCapacity();
        }
    }

    private void resizeUpdateCapacity() {
        int newCapacity = this.maxHist * 3 / 2;
        IStateBinaryTree[] tmp1 = new IStateBinaryTree[newCapacity];
        System.arraycopy(this.treeStack, 0, tmp1, 0, this.treeStack.length);
        this.treeStack = tmp1;
        IStateBinaryTree.Node[] tmp2 = new IStateBinaryTree.Node[newCapacity];
        System.arraycopy(this.nodeStack, 0, tmp2, 0, this.nodeStack.length);
        this.nodeStack = tmp2;
        int[] tmp3 = new int[newCapacity];
        System.arraycopy(this.opStack, 0, tmp3, 0, this.opStack.length);
        this.opStack = tmp3;
        int[] tmp4 = new int[newCapacity];
        System.arraycopy(this.oldValues, 0, tmp4, 0, this.oldValues.length);
        this.oldValues = tmp4;
        int[] tmp5 = new int[newCapacity];
        System.arraycopy(this.stampStack, 0, tmp5, 0, this.stampStack.length);
        this.stampStack = tmp5;
        this.maxHist = newCapacity;
    }

    @Override
    public void worldPush() {
        this.worldStartLevels[this.environment.getWorldIndex() + 1] = this.currentLevel;
    }

    @Override
    public void worldPop() {
        while (this.currentLevel > this.worldStartLevels[this.environment.getWorldIndex()]) {
            --this.currentLevel;
            IStateBinaryTree b = this.treeStack[this.currentLevel];
            IStateBinaryTree.Node n = this.nodeStack[this.currentLevel];
            int operation = this.opStack[this.currentLevel];
            switch (operation) {
                case 0: {
                    n._setInf(this.oldValues[this.currentLevel], this.stampStack[this.currentLevel]);
                    break;
                }
                case 1: {
                    n._setSup(this.oldValues[this.currentLevel], this.stampStack[this.currentLevel]);
                    break;
                }
                case 2: {
                    b.remove(n, false);
                    break;
                }
                case 3: {
                    n.leftNode = null;
                    n.rightNode = null;
                    n.father = null;
                    b.add(n, false);
                }
            }
        }
    }

    @Override
    public void worldCommit() {
    }

    @Override
    public int getSize() {
        return this.currentLevel;
    }

    @Override
    public void resizeWorldCapacity(int newWorldCapacity) {
        int[] tmp = new int[newWorldCapacity];
        System.arraycopy(this.worldStartLevels, 0, tmp, 0, this.worldStartLevels.length);
        this.worldStartLevels = tmp;
    }
}

