/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing;

import choco.kernel.common.util.IntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBinaryTree;
import choco.kernel.memory.trailing.EnvironmentTrailing;
import choco.kernel.memory.trailing.StoredBinaryTreeTrail;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StoredBinaryTree
implements IStateBinaryTree {
    EnvironmentTrailing env;
    StoredBinaryTreeTrail trail;
    IStateBinaryTree.Node root;
    int lastSavedWorld;
    boolean addLeft = true;
    boolean remLeft = true;

    public StoredBinaryTree(EnvironmentTrailing env, int a, int b) {
        this.env = env;
        this.trail = (StoredBinaryTreeTrail)env.getTrail(6);
        this.lastSavedWorld = 0;
        this.add(a, b);
    }

    @Override
    public int getSize() {
        int out = 0;
        IntIterator it = this.getIterator();
        while (it.hasNext()) {
            it.next();
            ++out;
        }
        return out;
    }

    @Override
    public IStateBinaryTree.Node find(int value) {
        IStateBinaryTree.Node current = this.root;
        while (current != null) {
            if (current.contains(value)) {
                return current;
            }
            if (value < current.inf) {
                current = current.leftNode;
                continue;
            }
            current = current.rightNode;
        }
        return current;
    }

    @Override
    public IStateBinaryTree.Node nextNode(int value) {
        IStateBinaryTree.Node current = this.root;
        while (current != null) {
            IStateBinaryTree.Node n;
            if (current.contains(value + 1)) {
                return current;
            }
            if (value + 1 < current.inf) {
                n = current.leftNode;
                if (n == null) {
                    return current;
                }
                current = n;
                continue;
            }
            n = current.rightNode;
            if (n == null) {
                return this.nextNode(current);
            }
            current = n;
        }
        return null;
    }

    @Override
    public IStateBinaryTree.Node prevNode(int value) {
        IStateBinaryTree.Node current = this.root;
        while (current != null) {
            IStateBinaryTree.Node n;
            if (current.contains(value - 1)) {
                return current;
            }
            if (value - 1 < current.inf) {
                n = current.leftNode;
                if (n == null) {
                    return this.prevNode(current);
                }
                current = n;
                continue;
            }
            n = current.rightNode;
            if (n == null) {
                return current;
            }
            current = n;
        }
        return null;
    }

    @Override
    public void add(IStateBinaryTree.Node n) {
        this.add(n, true);
    }

    @Override
    public void remove(IStateBinaryTree.Node n) {
        this.remove(n, true);
    }

    @Override
    public void remove(IStateBinaryTree.Node n, boolean save) {
        if (save) {
            this.trail.stack(this, n, 3);
        }
        if (n.leftNode == null && n.rightNode == null) {
            if (n.father == null) {
                this.root = null;
            } else if (n.father.leftNode == n) {
                n.father.leftNode = null;
            } else {
                n.father.rightNode = null;
            }
        } else if (n.leftNode == null) {
            n.rightNode.father = n.father;
            if (n.father == null) {
                this.root = n.rightNode;
            } else if (n.father.leftNode == n) {
                n.father.leftNode = n.rightNode;
            } else {
                n.father.rightNode = n.rightNode;
            }
        } else if (n.rightNode == null) {
            n.leftNode.father = n.father;
            if (n.father == null) {
                this.root = n.leftNode;
            } else if (n.father.leftNode == n) {
                n.father.leftNode = n.leftNode;
            } else {
                n.father.rightNode = n.leftNode;
            }
        } else {
            IStateBinaryTree.Node curFat;
            IStateBinaryTree.Node curSon;
            IStateBinaryTree.Node current;
            if (this.remLeft) {
                current = n.leftNode;
                while (current.rightNode != null) {
                    current = current.rightNode;
                }
                curSon = current.leftNode;
                curFat = current.father;
            } else {
                current = n.rightNode;
                while (current.leftNode != null) {
                    current = current.leftNode;
                }
                curSon = current.rightNode;
                curFat = current.father;
            }
            if (curFat != n) {
                current.rightNode = n.rightNode;
                current.leftNode = n.leftNode;
                current.rightNode.father = current;
                current.leftNode.father = current;
                if (this.remLeft) {
                    curFat.rightNode = curSon;
                } else {
                    curFat.leftNode = curSon;
                }
                if (curSon != null) {
                    curSon.father = curFat;
                }
            } else if (this.remLeft) {
                current.rightNode = n.rightNode;
                current.rightNode.father = current;
            } else {
                current.leftNode = n.leftNode;
                current.leftNode.father = current;
            }
            current.father = n.father;
            if (current.father == null) {
                this.root = current;
            } else if (current.father.leftNode == n) {
                current.father.leftNode = current;
            } else {
                current.father.rightNode = current;
            }
            this.remLeft = !this.remLeft;
        }
    }

    @Override
    public void add(int a, int b) {
        this.add(new IStateBinaryTree.Node(this, a, b), false);
    }

    @Override
    public void add(IStateBinaryTree.Node n, boolean save) {
        if (save) {
            this.trail.stack(this, n, 2);
        }
        IStateBinaryTree.Node current = this.root;
        boolean done = false;
        if (current == null) {
            this.root = n;
            done = true;
        }
        while (!done) {
            if (current.inf > n.inf) {
                if (current.leftNode == null) {
                    current.leftNode = n;
                    n.father = current;
                    done = true;
                    continue;
                }
                current = current.leftNode;
                continue;
            }
            if (current.inf < n.inf) {
                if (current.rightNode == null) {
                    current.rightNode = n;
                    n.father = current;
                    done = true;
                    continue;
                }
                current = current.rightNode;
                continue;
            }
            System.err.println("GFROS PB");
            done = true;
        }
    }

    @Override
    public IStateBinaryTree.Node getRoot() {
        return this.root;
    }

    @Override
    public IStateBinaryTree.Node prevNode(IStateBinaryTree.Node n) {
        IStateBinaryTree.Node cur = n;
        if (cur.leftNode != null) {
            cur = cur.leftNode;
            while (cur.rightNode != null) {
                cur = cur.rightNode;
            }
            return cur;
        }
        if (cur.father == null) {
            return null;
        }
        if (cur.father.rightNode == cur) {
            return cur.father;
        }
        while (cur.father != null && cur.father.leftNode == cur) {
            cur = cur.father;
        }
        return cur.father;
    }

    @Override
    public IStateBinaryTree.Node nextNode(IStateBinaryTree.Node n) {
        IStateBinaryTree.Node cur = n;
        if (cur.rightNode != null) {
            cur = cur.rightNode;
            while (cur.leftNode != null) {
                cur = cur.leftNode;
            }
            return cur;
        }
        if (cur.father == null) {
            return null;
        }
        if (cur.father.leftNode == cur) {
            return cur.father;
        }
        while (cur.father != null && cur.father.rightNode == cur) {
            cur = cur.father;
        }
        return cur.father;
    }

    @Override
    public boolean remove(int value) {
        IStateBinaryTree.Node container = this.find(value);
        if (container == null) {
            return false;
        }
        if (container.getSize() == 1) {
            this.remove(container, true);
        } else if (container.inf == value) {
            container.setInf(container.inf + 1);
        } else if (container.sup == value) {
            container.setSup(container.sup - 1);
        } else {
            IStateBinaryTree.Node n2;
            if (this.addLeft) {
                n2 = new IStateBinaryTree.Node(this, value + 1, container.sup);
                container.setSup(value - 1);
            } else {
                n2 = new IStateBinaryTree.Node(this, container.inf, value - 1);
                container.setInf(value + 1);
            }
            this.add(n2);
            this.addLeft = !this.addLeft;
        }
        return true;
    }

    @Override
    public StoredBinaryTreeTrail getTrail() {
        return this.trail;
    }

    @Override
    public IEnvironment getEnvironment() {
        return this.env;
    }

    @Override
    public IStateBinaryTree.Node getFirstNode() {
        IStateBinaryTree.Node current = this.root;
        if (current == null) {
            return null;
        }
        while (current.leftNode != null) {
            current = current.leftNode;
        }
        return current;
    }

    @Override
    public IStateBinaryTree.Node getLastNode() {
        IStateBinaryTree.Node current = this.root;
        if (current == null) {
            return null;
        }
        while (current.rightNode != null) {
            current = current.rightNode;
        }
        return current;
    }

    private void rem(int value) {
        this.remove(value);
    }

    @Override
    public String toString() {
        return this.toListString();
    }

    @Override
    public IntIterator getIterator() {
        return new TreeIterator();
    }

    public List<IStateBinaryTree.Node> toList() {
        ArrayList<IStateBinaryTree.Node> out = new ArrayList<IStateBinaryTree.Node>();
        IStateBinaryTree.Node current = this.getFirstNode();
        while (current != null) {
            out.add(current);
            current = this.nextNode(current);
        }
        return out;
    }

    public String toListString() {
        StringBuffer buf = new StringBuffer("[");
        List<IStateBinaryTree.Node> tmp = this.toList();
        for (IStateBinaryTree.Node iv : tmp) {
            buf.append(iv.toString()).append(" ");
        }
        if (!tmp.isEmpty()) {
            buf.deleteCharAt(buf.length() - 1);
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public String toDotty() {
        String s = "digraph binary_tree_domain {\n";
        s = s + this.toDotty(this.root);
        s = s + "\n}";
        return s;
    }

    public String toDotty(IStateBinaryTree.Node n) {
        String s = "";
        if (n.leftNode != null) {
            s = s + "\"" + n + "\" -> \"" + n.leftNode + "\";\n";
            s = s + this.toDotty(n.leftNode);
        }
        if (n.rightNode != null) {
            s = s + "\"" + n + "\" -> \"" + n.rightNode + "\";\n";
            s = s + this.toDotty(n.rightNode);
        }
        return s;
    }

    public static void print(IStateBinaryTree b) {
        String f = "bui.dot";
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File(f)));
            bw.write(b.toDotty());
            bw.flush();
            bw.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public class TreeIterator
    implements IntIterator {
        int currentValue = Integer.MIN_VALUE;
        IStateBinaryTree.Node currentNode;
        IStateBinaryTree.Node lastNode;

        public TreeIterator() {
            this.currentNode = StoredBinaryTree.this.getFirstNode();
            this.lastNode = StoredBinaryTree.this.getLastNode();
        }

        @Override
        public boolean hasNext() {
            return this.lastNode != null && this.currentValue < this.lastNode.sup;
        }

        @Override
        public int next() {
            if (this.currentValue == Integer.MIN_VALUE) {
                this.currentValue = this.currentNode.inf;
            } else if (this.currentValue + 1 <= this.currentNode.sup) {
                ++this.currentValue;
            } else {
                this.currentNode = StoredBinaryTree.this.nextNode(this.currentNode);
                this.currentValue = this.currentNode.inf;
            }
            return this.currentValue;
        }

        @Override
        public void remove() {
            StoredBinaryTree.this.rem(this.currentValue);
            this.currentNode = StoredBinaryTree.this.nextNode(this.currentValue);
            this.lastNode = StoredBinaryTree.this.getLastNode();
        }
    }
}

