/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing;

import choco.kernel.memory.AbstractEnvironment;
import choco.kernel.memory.AbstractStateBitSet;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBinaryTree;
import choco.kernel.memory.IStateBool;
import choco.kernel.memory.IStateDouble;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.IStateIntProcedure;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.memory.IStateLong;
import choco.kernel.memory.IStateVector;
import choco.kernel.memory.PartiallyStoredIntVector;
import choco.kernel.memory.PartiallyStoredVector;
import choco.kernel.memory.trailing.ITrailStorage;
import choco.kernel.memory.trailing.IndexedObject;
import choco.kernel.memory.trailing.StoredBinaryTree;
import choco.kernel.memory.trailing.StoredBinaryTreeTrail;
import choco.kernel.memory.trailing.StoredBitSet;
import choco.kernel.memory.trailing.StoredBool;
import choco.kernel.memory.trailing.StoredBoolTrail;
import choco.kernel.memory.trailing.StoredDouble;
import choco.kernel.memory.trailing.StoredDoubleTrail;
import choco.kernel.memory.trailing.StoredIndexedBipartiteSet;
import choco.kernel.memory.trailing.StoredInt;
import choco.kernel.memory.trailing.StoredIntBipartiteList;
import choco.kernel.memory.trailing.StoredIntProcedure;
import choco.kernel.memory.trailing.StoredIntTrail;
import choco.kernel.memory.trailing.StoredIntVector;
import choco.kernel.memory.trailing.StoredIntVectorTrail;
import choco.kernel.memory.trailing.StoredLong;
import choco.kernel.memory.trailing.StoredLongTrail;
import choco.kernel.memory.trailing.StoredVector;
import choco.kernel.memory.trailing.StoredVectorTrail;
import java.util.ArrayList;

public class EnvironmentTrailing
extends AbstractEnvironment {
    private int maxHist = 5000;
    private int maxWorld = 100;
    protected ITrailStorage[] trails = new ITrailStorage[]{new StoredBoolTrail(this, this.maxHist, this.maxWorld), new StoredIntTrail(this, this.maxHist, this.maxWorld), new StoredVectorTrail(this, this.maxHist, this.maxWorld), new StoredIntVectorTrail(this, this.maxHist, this.maxWorld), new StoredDoubleTrail(this, this.maxHist, this.maxWorld), new StoredLongTrail(this, this.maxHist, this.maxWorld), new StoredBinaryTreeTrail(this, this.maxHist, this.maxWorld)};

    public ITrailStorage getTrail(int i) {
        return this.trails[i];
    }

    @Override
    public void worldPush() {
        for (ITrailStorage trail : this.trails) {
            trail.worldPush();
        }
        ++this.currentWorld;
        if (this.currentWorld + 1 == this.maxWorld) {
            this.resizeWorldCapacity(this.maxWorld * 3 / 2);
        }
    }

    @Override
    public void worldPop() {
        for (ITrailStorage trail : this.trails) {
            trail.worldPop();
        }
        --this.currentWorld;
    }

    public void worldCommit() {
        if (this.currentWorld == 0) {
            throw new IllegalStateException("Commit in world 0?");
        }
        for (ITrailStorage trail : this.trails) {
            trail.worldCommit();
        }
        --this.currentWorld;
    }

    @Override
    public IStateInt makeInt() {
        return this.makeInt(0);
    }

    @Override
    public IStateInt makeInt(int initialValue) {
        return new StoredInt(this, initialValue);
    }

    @Override
    public IStateInt makeIntProcedure(IStateIntProcedure procedure, int initialValue) {
        return new StoredIntProcedure(this, procedure, initialValue);
    }

    @Override
    public IStateBool makeBool(boolean initialValue) {
        return new StoredBool(this, initialValue);
    }

    @Override
    public IStateIntVector makeIntVector() {
        return new StoredIntVector(this);
    }

    @Override
    public IStateIntVector makeIntVector(int size, int initialValue) {
        return new StoredIntVector(this, size, initialValue);
    }

    @Override
    public IStateIntVector makeIntVector(int[] entries) {
        return new StoredIntVector(this, entries);
    }

    @Override
    public IStateIntVector makeBipartiteIntList(int[] entries) {
        return new StoredIntBipartiteList(this, entries);
    }

    @Override
    public IStateIntVector makeBipartiteSet(int[] entries) {
        return new StoredIndexedBipartiteSet((IEnvironment)this, entries);
    }

    @Override
    public IStateIntVector makeBipartiteSet(int nbEntries) {
        return new StoredIndexedBipartiteSet((IEnvironment)this, nbEntries);
    }

    @Override
    public IStateIntVector makeBipartiteSet(IndexedObject[] entries) {
        return new StoredIndexedBipartiteSet((IEnvironment)this, entries);
    }

    @Override
    public IStateIntVector makeBipartiteSet(ArrayList<IndexedObject> entries) {
        return new StoredIndexedBipartiteSet((IEnvironment)this, entries);
    }

    @Override
    public void increaseSizeOfSharedBipartiteSet(int gap) {
        ((StoredIndexedBipartiteSet)this.currentBitSet).increaseSize(gap);
    }

    @Override
    public <T> IStateVector<T> makeVector() {
        return new StoredVector(this);
    }

    @Override
    public <T> PartiallyStoredVector<T> makePartiallyStoredVector() {
        return new PartiallyStoredVector(this);
    }

    @Override
    public PartiallyStoredIntVector makePartiallyStoredIntVector() {
        return new PartiallyStoredIntVector(this);
    }

    @Override
    public AbstractStateBitSet makeBitSet(int size) {
        return new StoredBitSet(this, size);
    }

    public AbstractStateBitSet makeBitSet(int[] entries) {
        return new StoredBitSet(this, 0);
    }

    @Override
    public IStateDouble makeFloat() {
        return this.makeFloat(Double.NaN);
    }

    @Override
    public IStateDouble makeFloat(double initialValue) {
        return new StoredDouble(this, initialValue);
    }

    @Override
    public IStateBinaryTree makeBinaryTree(int inf, int sup) {
        return new StoredBinaryTree(this, inf, sup);
    }

    @Override
    public IStateLong makeLong() {
        return this.makeLong(0);
    }

    @Override
    public IStateLong makeLong(int init) {
        return new StoredLong(this, init);
    }

    public int getTrailSize() {
        int s = 0;
        for (ITrailStorage trail : this.trails) {
            s += trail.getSize();
        }
        return s;
    }

    public int getIntTrailSize() {
        return this.trails[1].getSize();
    }

    public int getBoolTrailSize() {
        return this.trails[0].getSize();
    }

    public int getIntVectorTrailSize() {
        return this.trails[3].getSize();
    }

    public int getFloatTrailSize() {
        return this.trails[4].getSize();
    }

    public int getLongTrailSize() {
        return this.trails[5].getSize();
    }

    public int getVectorTrailSize() {
        return this.trails[2].getSize();
    }

    public int getBinaryTreeTrailSize() {
        return this.trails[6].getSize();
    }

    private void resizeWorldCapacity(int newWorldCapacity) {
        for (ITrailStorage trail : this.trails) {
            trail.resizeWorldCapacity(newWorldCapacity);
        }
        this.maxWorld = newWorldCapacity;
    }
}

