/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.recomputation;

import choco.kernel.memory.AbstractEnvironment;
import choco.kernel.memory.AbstractStateBitSet;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBinaryTree;
import choco.kernel.memory.IStateBool;
import choco.kernel.memory.IStateDouble;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.IStateIntProcedure;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.memory.IStateLong;
import choco.kernel.memory.IStateVector;
import choco.kernel.memory.PartiallyStoredIntVector;
import choco.kernel.memory.PartiallyStoredVector;
import choco.kernel.memory.copy.EnvironmentCopying;
import choco.kernel.memory.trailing.EnvironmentTrailing;
import choco.kernel.memory.trailing.IndexedObject;
import choco.kernel.memory.trailing.StoredIndexedBipartiteSet;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.search.AbstractSearchStrategy;
import choco.kernel.solver.search.IntBranchingTrace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

public class EnvironmentRecomputation
extends AbstractEnvironment {
    public IEnvironment delegatedEnv;
    public int lastFail;
    AbstractSearchStrategy strategy;
    Stack<Integer> savedWorldIdxStack;
    Map<Integer, Vector<BranchTrace>> contexts;
    public int lastSavedWorld;
    private int nbPush = 0;
    private int nbFail = 0;
    private int gap;

    public EnvironmentRecomputation() {
        this(new EnvironmentTrailing(), Integer.MAX_VALUE);
    }

    public EnvironmentRecomputation(int envType, int gap) {
        switch (envType) {
            case 0: {
                this.delegatedEnv = new EnvironmentTrailing();
                break;
            }
            case 1: {
                this.delegatedEnv = new EnvironmentCopying();
                break;
            }
            default: {
                this.delegatedEnv = new EnvironmentTrailing();
            }
        }
        this.currentWorld = 0;
        this.savedWorldIdxStack = new Stack();
        this.contexts = new HashMap<Integer, Vector<BranchTrace>>();
        this.gap = gap;
    }

    public EnvironmentRecomputation(IEnvironment envD, int gap) {
        this.currentWorld = 0;
        this.savedWorldIdxStack = new Stack();
        this.contexts = new HashMap<Integer, Vector<BranchTrace>>();
        this.gap = gap;
        this.delegatedEnv = envD;
    }

    @Override
    public void worldPush() {
        if (this.currentWorld == 0 || (this.currentWorld - 1) % this.gap == 0 || (this.lastFail - this.savedWorldIdxStack.peek()) / 2 == this.currentWorld) {
            this.delegatedEnv.worldPush();
            this.lastSavedWorld = this.currentWorld;
            this.savedWorldIdxStack.push(this.currentWorld);
            ++this.nbPush;
        }
        ++this.currentWorld;
    }

    @Override
    public void worldPop() {
        this.delegatedEnv.worldPop();
        this.lastSavedWorld = this.savedWorldIdxStack.peek();
        --this.currentWorld;
        if (this.lastSavedWorld == 0) {
            return;
        }
        if (this.lastSavedWorld - this.currentWorld == 0) {
            this.savedWorldIdxStack.pop();
            this.lastSavedWorld = this.savedWorldIdxStack.peek();
        } else {
            this.delegatedEnv.worldPush();
            for (int i = this.lastSavedWorld; i < this.currentWorld; ++i) {
                for (BranchTrace trace : this.contexts.get(i)) {
                    try {
                        if (trace.isDown) {
                            trace.ctx.getBranching().goDownBranch(trace.ctx.getBranchingObject(), trace.ctx.getBranchIndex());
                            continue;
                        }
                        trace.ctx.getBranching().goUpBranch(trace.ctx.getBranchingObject(), trace.ctx.getBranchIndex());
                    }
                    catch (ContradictionException e) {
                        System.out.println("bizarre");
                    }
                }
            }
            this.contexts.remove(this.currentWorld + 1);
        }
    }

    public void worldCommit() {
    }

    @Override
    public IStateInt makeInt() {
        return this.delegatedEnv.makeInt();
    }

    @Override
    public IStateInt makeInt(int initialValue) {
        return this.delegatedEnv.makeInt(initialValue);
    }

    @Override
    public IStateInt makeIntProcedure(IStateIntProcedure procedure, int initialValue) {
        return this.delegatedEnv.makeIntProcedure(procedure, initialValue);
    }

    @Override
    public IStateBool makeBool(boolean initialValue) {
        return this.delegatedEnv.makeBool(initialValue);
    }

    @Override
    public IStateIntVector makeIntVector() {
        return this.delegatedEnv.makeIntVector();
    }

    @Override
    public IStateIntVector makeIntVector(int size, int initialValue) {
        return this.delegatedEnv.makeIntVector(size, initialValue);
    }

    @Override
    public IStateIntVector makeIntVector(int[] entries) {
        return this.delegatedEnv.makeIntVector(entries);
    }

    @Override
    public <T> PartiallyStoredVector<T> makePartiallyStoredVector() {
        return this.delegatedEnv.makePartiallyStoredVector();
    }

    @Override
    public PartiallyStoredIntVector makePartiallyStoredIntVector() {
        return this.delegatedEnv.makePartiallyStoredIntVector();
    }

    @Override
    public AbstractStateBitSet makeBitSet(int size) {
        return this.delegatedEnv.makeBitSet(size);
    }

    @Override
    public IStateIntVector makeBipartiteIntList(int[] entries) {
        return this.delegatedEnv.makeBipartiteIntList(entries);
    }

    @Override
    public IStateIntVector makeBipartiteSet(int[] entries) {
        return this.delegatedEnv.makeBipartiteSet(entries);
    }

    @Override
    public IStateIntVector makeBipartiteSet(int entries) {
        return this.delegatedEnv.makeBipartiteSet(entries);
    }

    @Override
    public IStateIntVector makeBipartiteSet(IndexedObject[] entries) {
        return this.delegatedEnv.makeBipartiteSet(entries);
    }

    @Override
    public IStateIntVector makeBipartiteSet(ArrayList<IndexedObject> entries) {
        return this.delegatedEnv.makeBipartiteSet(entries);
    }

    @Override
    public void increaseSizeOfSharedBipartiteSet(int gap) {
        ((StoredIndexedBipartiteSet)((AbstractEnvironment)this.delegatedEnv).currentBitSet).increaseSize(gap);
    }

    @Override
    public IStateDouble makeFloat() {
        return this.delegatedEnv.makeFloat();
    }

    @Override
    public IStateDouble makeFloat(double initialValue) {
        return this.delegatedEnv.makeFloat(initialValue);
    }

    @Override
    public IStateLong makeLong() {
        return this.delegatedEnv.makeLong();
    }

    @Override
    public IStateLong makeLong(int init) {
        return this.delegatedEnv.makeLong(init);
    }

    @Override
    public <T> IStateVector<T> makeVector() {
        return this.delegatedEnv.makeVector();
    }

    @Override
    public IStateBinaryTree makeBinaryTree(int inf, int sup) {
        return this.delegatedEnv.makeBinaryTree(inf, sup);
    }

    public void pushContext(IntBranchingTrace ctx, boolean isDown) {
        if (this.contexts.get(this.currentWorld) == null) {
            Vector v = new Vector();
            this.contexts.put(this.currentWorld, v);
        }
        this.contexts.get(this.currentWorld).add(new BranchTrace(ctx, isDown));
    }

    public void setLastFail(int worldIndex) {
        this.lastFail = worldIndex;
    }

    public int getNbSaves() {
        return this.nbPush;
    }

    public int getLastSavedIndex() {
        return this.lastSavedWorld;
    }

    public void incNbFail() {
        ++this.nbFail;
    }

    public int getNbFail() {
        return this.nbFail;
    }

    private final class BranchTrace {
        public final boolean isDown;
        public final IntBranchingTrace ctx;

        public BranchTrace(IntBranchingTrace ctx, boolean isDown) {
            this.ctx = ctx;
            this.isDown = isDown;
        }
    }
}

