/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.copy;

import choco.kernel.memory.IStateVector;
import choco.kernel.memory.copy.EnvironmentCopying;
import choco.kernel.memory.copy.RcInt;
import choco.kernel.memory.copy.RecomputableElement;
import java.util.logging.Logger;

public class RcVector<E>
implements IStateVector<E>,
RecomputableElement {
    private static Logger logger = Logger.getLogger("choco.kernel.memory");
    private Object[] elementData;
    private RcInt size;
    private final EnvironmentCopying environment;
    private int timeStamp;

    public RcVector(EnvironmentCopying env) {
        int initialCapacity = 8;
        int w = env.getWorldIndex();
        this.environment = env;
        this.elementData = new Object[initialCapacity];
        this.timeStamp = env.getWorldIndex();
        this.size = new RcInt(env, 0);
        env.add(this);
    }

    public RcVector(int[] entries) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size.get());
        }
    }

    @Override
    public boolean add(E i) {
        this.timeStamp = this.environment.getWorldIndex();
        int newsize = this.size.get() + 1;
        this.ensureCapacity(newsize);
        this.size.set(newsize);
        this.elementData[newsize - 1] = i;
        return true;
    }

    @Override
    public void removeLast() {
        this.timeStamp = this.environment.getWorldIndex();
        int newsize = this.size.get() - 1;
        if (newsize >= 0) {
            this.size.set(newsize);
        }
    }

    @Override
    public E get(int index) {
        if (index < this.size.get() && index >= 0) {
            return (E)this.elementData[index];
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    @Override
    public E set(int index, E val) {
        if (index < this.size.get() && index >= 0) {
            Object oldValue = this.elementData[index];
            if (val != oldValue) {
                this.elementData[index] = val;
            }
            this.timeStamp = this.environment.getWorldIndex();
            return (E)oldValue;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    public void _set(E[] vals) {
        this.timeStamp = this.environment.getWorldIndex();
        System.arraycopy(vals, 0, this.elementData, 0, vals.length);
    }

    public E[] deepCopy() {
        Object[] ret = new Object[this.size.get()];
        System.arraycopy(this.elementData, 0, ret, 0, this.size.get());
        return ret;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public int getTimeStamp() {
        return this.timeStamp;
    }
}

