/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.copy;

import choco.kernel.memory.copy.EnvironmentCopying;
import choco.kernel.memory.copy.RcBitSet;
import choco.kernel.memory.copy.RcBool;
import choco.kernel.memory.copy.RcInt;
import choco.kernel.memory.copy.RcIntVector;
import choco.kernel.memory.copy.RcVector;
import choco.kernel.memory.copy.RecomputableElement;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class RcSave
implements RecomputableElement {
    public RecomputableElement[][] currentElement;
    private EnvironmentCopying environment;
    private int lastSavedWorldIndex;
    private Map<Integer, int[]> saveInt;
    private Map<Integer, Object[][]> saveVector;
    private Map<Integer, int[][]> saveIntVector;
    private Map<Integer, boolean[]> saveBool;
    private Map<Integer, BitSet[]> saveBitSet;

    public RcSave(EnvironmentCopying env) {
        this.environment = env;
        this.currentElement = env.test;
        this.lastSavedWorldIndex = env.getWorldIndex();
        this.saveInt = new HashMap<Integer, int[]>();
        this.saveVector = new HashMap<Integer, Object[][]>();
        this.saveIntVector = new HashMap<Integer, int[][]>();
        this.saveBool = new HashMap<Integer, boolean[]>();
        this.saveBitSet = new HashMap<Integer, BitSet[]>();
    }

    public void save(int worldIndex) {
        int i;
        if (this.lastSavedWorldIndex >= worldIndex) {
            this.lastSavedWorldIndex = 0;
        }
        boolean[] tmpbool = new boolean[this.currentElement[0].length];
        for (i = 0; i < this.currentElement[0].length; ++i) {
            tmpbool[i] = ((RcBool)this.currentElement[0][i]).deepCopy();
        }
        this.saveBool.put(worldIndex, tmpbool);
        int[] tmpint = new int[this.currentElement[1].length];
        i = 0;
        for (i = 0; i < this.currentElement[1].length; ++i) {
            tmpint[i] = ((RcInt)this.currentElement[1][i]).deepCopy();
        }
        this.saveInt.put(worldIndex, tmpint);
        Object[][] tmpvec = new Object[this.currentElement[2].length][];
        i = 0;
        for (i = 0; i < this.currentElement[2].length; ++i) {
            tmpvec[i] = worldIndex != 0 && this.lastSavedWorldIndex >= this.currentElement[2][i].getTimeStamp() ? this.saveVector.get(this.lastSavedWorldIndex)[i] : ((RcVector)this.currentElement[2][i]).deepCopy();
        }
        this.saveVector.put(worldIndex, tmpvec);
        int[][] tmpintvec = new int[this.currentElement[3].length][];
        i = 0;
        for (i = 0; i < this.currentElement[3].length; ++i) {
            tmpintvec[i] = worldIndex != 0 && this.lastSavedWorldIndex >= this.currentElement[3][i].getTimeStamp() ? this.saveIntVector.get(this.lastSavedWorldIndex)[i] : ((RcIntVector)this.currentElement[3][i]).deepCopy();
        }
        this.saveIntVector.put(worldIndex, tmpintvec);
        BitSet[] tmpbitset = new BitSet[this.currentElement[4].length];
        for (i = 0; i < this.currentElement[4].length; ++i) {
            tmpbitset[i] = worldIndex != 0 && this.lastSavedWorldIndex >= this.currentElement[4][i].getTimeStamp() ? this.saveBitSet.get(this.lastSavedWorldIndex)[i] : (BitSet)((RcBitSet)this.currentElement[4][i]).getBitSet().clone();
        }
        this.saveBitSet.put(worldIndex, tmpbitset);
        this.lastSavedWorldIndex = worldIndex;
    }

    public void restore(int worldIndex) {
        int i;
        boolean[] tmpbool = this.saveBool.get(worldIndex);
        int[] tmpint = this.saveInt.get(worldIndex);
        Object[][] tmpvec = this.saveVector.get(worldIndex);
        int[][] tmpintvec = this.saveIntVector.get(worldIndex);
        BitSet[] tmpbitset = this.saveBitSet.get(worldIndex);
        for (i = 0; i < tmpbool.length; ++i) {
            ((RcBool)this.currentElement[0][i]).set(tmpbool[i]);
        }
        for (i = 0; i < tmpint.length; ++i) {
            ((RcInt)this.currentElement[1][i]).set(tmpint[i]);
        }
        for (i = 0; i < tmpvec.length; ++i) {
            ((RcVector)this.currentElement[2][i])._set(tmpvec[i]);
        }
        for (i = 0; i < tmpintvec.length; ++i) {
            ((RcIntVector)this.currentElement[3][i])._set(tmpintvec[i]);
        }
        for (i = 0; i < tmpbitset.length; ++i) {
            ((RcBitSet)this.currentElement[4][i])._set(tmpbitset[i]);
        }
        if (worldIndex == 0) {
            this.clearMaps();
        } else {
            this.remove(worldIndex + 1);
        }
    }

    public void remove(int worldIndex) {
        this.saveInt.remove(worldIndex);
        this.saveVector.remove(worldIndex);
        this.saveIntVector.remove(worldIndex);
        this.saveBool.remove(worldIndex);
        this.saveBitSet.remove(worldIndex);
    }

    private void clearMaps() {
        this.saveInt.clear();
        this.saveVector.clear();
        this.saveIntVector.clear();
        this.saveBool.clear();
        this.saveBitSet.clear();
    }

    @Override
    public int getType() {
        return -1;
    }

    @Override
    public int getTimeStamp() {
        return 0;
    }
}

