/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.copy;

import choco.kernel.common.util.IntIterator;
import choco.kernel.memory.AbstractStateBitSet;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.memory.copy.EnvironmentCopying;
import choco.kernel.memory.copy.RecomputableElement;
import java.util.BitSet;

public class RcBitSet
extends AbstractStateBitSet
implements RecomputableElement {
    private BitSet representedBy;
    private EnvironmentCopying env;
    private int timeStamp;

    public RcBitSet(EnvironmentCopying env, int initialSize) {
        this(env, initialSize, false);
    }

    public RcBitSet(EnvironmentCopying env, int initialSize, boolean fixed) {
        this.representedBy = new BitSet(initialSize);
        this.timeStamp = env.getWorldIndex();
        this.env = env;
        env.add(this);
    }

    @Override
    public int cardinality() {
        return this.representedBy.cardinality();
    }

    @Override
    public int size() {
        return this.representedBy.size();
    }

    @Override
    public void set(int bitIndex) {
        this.timeStamp = this.env.getWorldIndex();
        this.representedBy.set(bitIndex);
    }

    @Override
    public void clear(int bitIndex) {
        this.timeStamp = this.env.getWorldIndex();
        this.representedBy.clear(bitIndex);
    }

    @Override
    public void clear() {
        this.representedBy.clear();
    }

    @Override
    public void set(int index, boolean value) {
        this.timeStamp = this.env.getWorldIndex();
        this.representedBy.set(index, value);
    }

    @Override
    public void set(int fromIdex, int toIndex) {
        for (int i = fromIdex; i < toIndex; ++i) {
            this.set(i);
        }
    }

    @Override
    public void or(IStateBitSet other) {
        RcBitSet set = (RcBitSet)other;
        this.representedBy.or(set.getBitSet());
    }

    @Override
    public void xor(IStateBitSet other) {
        RcBitSet set = (RcBitSet)other;
        this.representedBy.xor(set.getBitSet());
    }

    @Override
    public void and(IStateBitSet other) {
        RcBitSet set = (RcBitSet)other;
        this.representedBy.and(set.getBitSet());
    }

    @Override
    public void andNot(IStateBitSet other) {
        RcBitSet set = (RcBitSet)other;
        this.representedBy.andNot(set.getBitSet());
    }

    @Override
    public boolean intersects(IStateBitSet setI) {
        RcBitSet set = (RcBitSet)setI;
        return this.representedBy.intersects(set.getBitSet());
    }

    @Override
    public void flip(int bitIndex) {
        this.representedBy.flip(bitIndex);
    }

    @Override
    public void flip(int fromIndex, int toIndex) {
        this.representedBy.flip(fromIndex, toIndex);
    }

    @Override
    public boolean get(int bitIndex) {
        return this.representedBy.get(bitIndex);
    }

    @Override
    public int nextSetBit(int fromIndex) {
        return this.representedBy.nextSetBit(fromIndex);
    }

    @Override
    public int prevSetBit(int fromIndex) {
        int m;
        for (m = fromIndex; !this.representedBy.get(m) && m > -1; --m) {
        }
        return m;
    }

    @Override
    public int capacity() {
        return this.representedBy.size();
    }

    @Override
    public void ensureCapacity(int bitIndex) {
    }

    @Override
    public boolean isEmpty() {
        return this.representedBy.isEmpty();
    }

    public String pretty() {
        return "";
    }

    @Override
    public IntIterator getCycleButIterator(int avoidIndex) {
        int n = this.cardinality();
        if (avoidIndex != -1 && this.get(avoidIndex)) {
            --n;
        }
        if (n > 0) {
            return new IStateBitSet.CyclicIterator(this, avoidIndex);
        }
        return new IStateBitSet.EmptyIterator();
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public int getTimeStamp() {
        return this.timeStamp;
    }

    public void _set(BitSet bitSet) {
        if (bitSet.cardinality() <= 0) {
            System.out.println("bui");
            System.out.println("2");
        }
        this.timeStamp = this.env.getWorldIndex();
        BitSet b = (BitSet)bitSet.clone();
        if (b.cardinality() <= 0) {
            System.out.println("bui");
            System.out.println("2");
        }
        this.representedBy = b;
    }

    public BitSet getBitSet() {
        return this.representedBy;
    }
}

