/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.copy;

import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateIntInterval;
import choco.kernel.memory.copy.EnvironmentCopying;
import choco.kernel.memory.copy.RecomputableElement;

public class RCIntInterval
implements IStateIntInterval,
RecomputableElement {
    private int inf;
    private int sup;
    private int size;
    private int timeStamp;
    private final EnvironmentCopying environment;

    public RCIntInterval(EnvironmentCopying environment, int inf, int sup) {
        this.environment = environment;
        this.inf = inf;
        this.sup = sup;
        this.size = sup - inf + 1;
        environment.add(this);
        this.timeStamp = environment.getWorldIndex();
    }

    @Override
    public int getInf() {
        return this.inf;
    }

    @Override
    public void setInf(int inf) {
        this.inf = inf;
        this.timeStamp = this.environment.getWorldIndex();
    }

    @Override
    public void addInf(int delta) {
        this.setInf(this.getInf() + delta);
    }

    @Override
    public int getSup() {
        return this.sup;
    }

    @Override
    public void setSup(int sup) {
        this.sup = sup;
        this.timeStamp = this.environment.getWorldIndex();
    }

    @Override
    public void addSup(int delta) {
        this.setSup(this.getSup() + delta);
    }

    @Override
    public IEnvironment getEnvironment() {
        return this.environment;
    }

    public int[] deepCopy() {
        return new int[]{this.inf, this.sup};
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public int getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public boolean contains(int x) {
        return x <= this.sup && x >= this.inf;
    }
}

