/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory;

import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.MemoryException;
import java.util.NoSuchElementException;

public class PartiallyStoredVector<E> {
    public static final int INITIAL_STATIC_CAPACITY = 16;
    public static final int INITIAL_STORED_CAPACITY = 16;
    public static final int STORED_OFFSET = 1000000;
    protected Object[] staticObjects = new Object[16];
    protected Object[] storedObjects = new Object[16];
    protected int nStaticObjects = 0;
    protected IStateInt nStoredObjects;
    private PSVIndexIterator _cachedPSVIndexIterator;

    public PartiallyStoredVector(IEnvironment env) {
        this.nStoredObjects = env.makeInt(0);
    }

    public boolean contains(Object o) {
        int i;
        for (i = 0; i < this.nStaticObjects; ++i) {
            if (!this.staticObjects[i].equals(o)) continue;
            return true;
        }
        for (i = 0; i < this.nStoredObjects.get(); ++i) {
            if (!this.storedObjects[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    public int staticAdd(E o) {
        this.ensureStaticCapacity(this.nStaticObjects + 1);
        this.staticObjects[this.nStaticObjects++] = o;
        return this.nStaticObjects - 1;
    }

    public int staticInsert(int ind, E o) {
        this.ensureStaticCapacity(this.nStaticObjects++);
        for (int i = this.nStaticObjects; i > ind; --i) {
            this.staticObjects[i] = this.staticObjects[i - 1];
        }
        this.staticObjects[ind] = o;
        return this.nStaticObjects - 1;
    }

    protected void staticRemove(int idx) {
        this.staticObjects[idx] = null;
        if (idx == this.nStaticObjects - 1) {
            while (this.staticObjects[this.nStaticObjects] == null && this.nStaticObjects > 0) {
                --this.nStaticObjects;
            }
            if (this.staticObjects[this.nStaticObjects] != null) {
                ++this.nStaticObjects;
            }
        }
    }

    public int remove(Object o) {
        for (int i = 0; i < this.staticObjects.length; ++i) {
            Object staticObject = this.staticObjects[i];
            if (staticObject != o) continue;
            this.staticRemove(i);
            return i;
        }
        throw new MemoryException("impossible to remove the object (a constraint ?) from the static part of the collection (cut manager ?)");
    }

    public void ensureStaticCapacity(int n) {
        if (n >= this.staticObjects.length) {
            int newSize = this.staticObjects.length;
            while (n >= newSize) {
                newSize = 3 * newSize / 2;
            }
            Object[] newStaticObjects = new Object[newSize];
            System.arraycopy(this.staticObjects, 0, newStaticObjects, 0, this.staticObjects.length);
            this.staticObjects = newStaticObjects;
        }
    }

    public int add(E o) {
        this.ensureStoredCapacity(this.nStoredObjects.get() + 1);
        this.storedObjects[this.nStoredObjects.get()] = o;
        this.nStoredObjects.add(1);
        return 1000000 + this.nStoredObjects.get() - 1;
    }

    public int insert(int ind, E o) {
        this.ensureStoredCapacity(this.nStoredObjects.get() + 1);
        for (int i = this.nStoredObjects.get() + 1; i > ind; --i) {
            this.storedObjects[i] = this.storedObjects[i - 1];
        }
        this.storedObjects[ind] = o;
        this.nStoredObjects.add(1);
        return 1000000 + this.nStoredObjects.get() - 1;
    }

    public void ensureStoredCapacity(int n) {
        if (n >= this.storedObjects.length) {
            int newSize = this.storedObjects.length;
            while (n >= newSize) {
                newSize = 3 * newSize / 2;
            }
            Object[] newStoredObjects = new Object[newSize];
            System.arraycopy(this.storedObjects, 0, newStoredObjects, 0, this.storedObjects.length);
            this.storedObjects = newStoredObjects;
        }
    }

    public E get(int index) {
        if (index < 1000000) {
            return (E)this.staticObjects[index];
        }
        return (E)this.storedObjects[index - 1000000];
    }

    public boolean isEmpty() {
        return this.nStaticObjects == 0 && this.nStoredObjects.get() == 0;
    }

    public int size() {
        return this.nStaticObjects + this.nStoredObjects.get();
    }

    public DisposableIntIterator getIndexIterator() {
        if (this._cachedPSVIndexIterator != null && this._cachedPSVIndexIterator.disposed) {
            this._cachedPSVIndexIterator.disposed = false;
            return this._cachedPSVIndexIterator;
        }
        this._cachedPSVIndexIterator = new PSVIndexIterator();
        this._cachedPSVIndexIterator.disposed = false;
        return this._cachedPSVIndexIterator;
    }

    public static boolean isStaticIndex(int idx) {
        return idx < 1000000;
    }

    public static int getSmallIndex(int idx) {
        if (idx < 1000000) {
            return idx;
        }
        return idx - 1000000;
    }

    public static int getGlobalIndex(int idx, boolean isStatic) {
        if (isStatic) {
            return idx;
        }
        return idx + 1000000;
    }

    public int getLastStaticIndex() {
        return this.nStaticObjects - 1;
    }

    public static int getFirstStaticIndex() {
        return 0;
    }

    public int getLastStoredIndex() {
        return this.nStoredObjects.get() - 1;
    }

    private class PSVIndexIterator
    extends DisposableIntIterator {
        int idx = -1;
        boolean disposed = true;

        private PSVIndexIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.idx < 1000000) {
                if (this.idx + 1 < PartiallyStoredVector.this.nStaticObjects) {
                    return true;
                }
                return PartiallyStoredVector.this.nStoredObjects.get() > 0;
            }
            return this.idx + 1 < 1000000 + PartiallyStoredVector.this.nStoredObjects.get();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int next() {
            if (this.idx < 1000000) {
                if (this.idx + 1 < PartiallyStoredVector.this.nStaticObjects) {
                    ++this.idx;
                    while (PartiallyStoredVector.this.staticObjects[this.idx] == null && this.idx < PartiallyStoredVector.this.nStaticObjects) {
                        ++this.idx;
                    }
                    return this.idx;
                } else {
                    if (PartiallyStoredVector.this.nStoredObjects.get() <= 0) throw new NoSuchElementException();
                    this.idx = 1000000;
                }
                return this.idx;
            } else {
                if (this.idx + 1 >= 1000000 + PartiallyStoredVector.this.nStoredObjects.get()) throw new NoSuchElementException();
                ++this.idx;
            }
            return this.idx;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.idx = -1;
        }
    }
}

