/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory;

import choco.kernel.common.util.IntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;

public class PartiallyStoredIntVector {
    public static final int INITIAL_STATIC_CAPACITY = 16;
    public static final int INITIAL_STORED_CAPACITY = 16;
    public static final int STORED_OFFSET = 1000000;
    protected int[] staticInts = new int[16];
    protected int[] storedInts = new int[16];
    protected int nStaticInts = 0;
    protected IStateInt nStoredInts;

    public PartiallyStoredIntVector(IEnvironment env) {
        this.nStoredInts = env.makeInt(0);
    }

    public int staticAdd(int o) {
        this.ensureStaticCapacity(this.nStaticInts + 1);
        this.staticInts[this.nStaticInts++] = o;
        return this.nStaticInts - 1;
    }

    public void ensureStaticCapacity(int n) {
        if (n > this.staticInts.length) {
            int newSize = this.staticInts.length;
            while (n >= newSize) {
                newSize = 3 * newSize / 2;
            }
            int[] newStaticObjects = new int[newSize];
            System.arraycopy(this.staticInts, 0, newStaticObjects, 0, this.staticInts.length);
            this.staticInts = newStaticObjects;
        }
    }

    public int add(int o) {
        this.ensureStoredCapacity(this.nStoredInts.get() + 1);
        this.storedInts[this.nStoredInts.get()] = o;
        this.nStoredInts.add(1);
        return 1000000 + this.nStoredInts.get() - 1;
    }

    public void remove(int o) {
        this.staticInts[o] = this.staticInts[this.nStaticInts];
        this.staticInts[this.nStaticInts] = 0;
        --this.nStaticInts;
    }

    public void ensureStoredCapacity(int n) {
        if (n > this.storedInts.length) {
            int newSize = this.storedInts.length;
            while (n >= newSize) {
                newSize = 3 * newSize / 2;
            }
            int[] newStoredObjects = new int[newSize];
            System.arraycopy(this.storedInts, 0, newStoredObjects, 0, this.storedInts.length);
            this.storedInts = newStoredObjects;
        }
    }

    public int get(int index) {
        if (index < 1000000) {
            return this.staticInts[index];
        }
        return this.storedInts[index - 1000000];
    }

    public boolean isEmpty() {
        return this.nStaticInts == 0 && this.nStoredInts.get() == 0;
    }

    public int size() {
        return this.nStaticInts + this.nStoredInts.get();
    }

    public IntIterator getIndexIterator() {
        return new IntIterator(){
            int idx = -1;
            boolean stats;
            boolean storeds;
            {
                this.stats = PartiallyStoredIntVector.this.nStaticInts > 0;
                this.storeds = PartiallyStoredIntVector.this.nStoredInts.get() > 0;
            }

            @Override
            public boolean hasNext() {
                if (this.idx == -1) {
                    return this.stats || this.storeds;
                }
                return this.stats && this.idx < PartiallyStoredIntVector.this.nStaticInts - 1 || this.idx == PartiallyStoredIntVector.this.nStaticInts - 1 && this.storeds || this.storeds && 1000000 <= this.idx && this.idx < 1000000 + PartiallyStoredIntVector.this.nStoredInts.get() - 1;
            }

            @Override
            public int next() {
                ++this.idx;
                if (this.idx == PartiallyStoredIntVector.this.nStaticInts) {
                    this.idx = 1000000;
                }
                return this.idx;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static boolean isStaticIndex(int idx) {
        return idx < 1000000;
    }

    public static int getSmallIndex(int idx) {
        if (idx < 1000000) {
            return idx;
        }
        return idx - 1000000;
    }

    public static int getGlobalIndex(int idx, boolean isStatic) {
        if (isStatic) {
            return idx;
        }
        return idx + 1000000;
    }
}

