/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory;

import choco.kernel.common.util.IntIterator;

public interface IStateBitSet {
    public int cardinality();

    public int size();

    public void set(int var1);

    public void clear(int var1);

    public void clear();

    public void set(int var1, boolean var2);

    public void set(int var1, int var2);

    public boolean get(int var1);

    public int nextSetBit(int var1);

    public int prevSetBit(int var1);

    public int capacity();

    public void or(IStateBitSet var1);

    public void and(IStateBitSet var1);

    public void xor(IStateBitSet var1);

    public void andNot(IStateBitSet var1);

    public boolean intersects(IStateBitSet var1);

    public void flip(int var1);

    public void flip(int var1, int var2);

    public boolean isEmpty();

    public void ensureCapacity(int var1);

    public IntIterator getCycleButIterator(int var1);

    public static class CyclicIterator
    implements IntIterator {
        private int k;
        private int nextk;
        private int endMarker;
        private IStateBitSet bset;

        public CyclicIterator(IStateBitSet bs, int avoidIndex) {
            this.bset = bs;
            this.k = -1;
            this.nextk = -1;
            this.endMarker = avoidIndex;
        }

        @Override
        public boolean hasNext() {
            this.nextk = this.bset.nextSetBit(this.k + 1);
            if (this.nextk < 0) {
                return false;
            }
            if (this.nextk == this.endMarker) {
                this.nextk = this.bset.nextSetBit(this.nextk + 1);
                return this.nextk >= 0;
            }
            return true;
        }

        @Override
        public int next() {
            this.k = this.nextk;
            return this.k;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class EmptyIterator
    implements IntIterator {
        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int next() {
            return 0;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

