/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory;

import choco.kernel.common.util.IntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.trailing.StoredBinaryTreeTrail;

public interface IStateBinaryTree {
    public static final int INF = 0;
    public static final int SUP = 1;
    public static final int ADD = 2;
    public static final int REM = 3;

    public int getSize();

    public Node find(int var1);

    public void remove(Node var1);

    public void remove(Node var1, boolean var2);

    public void add(int var1, int var2);

    public void add(Node var1);

    public void add(Node var1, boolean var2);

    public Node getRoot();

    public boolean remove(int var1);

    public StoredBinaryTreeTrail getTrail();

    public IEnvironment getEnvironment();

    public Node getFirstNode();

    public Node getLastNode();

    public Node prevNode(Node var1);

    public Node nextNode(Node var1);

    public Node nextNode(int var1);

    public Node prevNode(int var1);

    public String toString();

    public IntIterator getIterator();

    public String toDotty();

    public static class Node {
        public int inf;
        public int sup;
        public int infStamp;
        public int supStamp;
        public IStateBinaryTree tree;
        public Node father;
        public Node leftNode;
        public Node rightNode;

        public Node(IStateBinaryTree tree, int inf, int sup) {
            this.tree = tree;
            this.inf = inf;
            this.sup = sup;
            this.infStamp = tree.getEnvironment().getWorldIndex();
            this.supStamp = tree.getEnvironment().getWorldIndex();
        }

        public boolean contains(int value) {
            return value >= this.inf && value <= this.sup;
        }

        public int getSize() {
            return this.sup - this.inf + 1;
        }

        public void _setInf(int newInf, int infStamp) {
            if (newInf != this.inf) {
                this.inf = newInf;
                this.infStamp = infStamp;
            }
        }

        public void setInf(int newInf) {
            if (newInf != this.inf) {
                if (this.infStamp <= this.tree.getEnvironment().getWorldIndex()) {
                    this.tree.getTrail().stack(this.tree, this, 0);
                    this.infStamp = this.tree.getEnvironment().getWorldIndex();
                }
                this.inf = newInf;
            }
        }

        public void _setSup(int newSup, int supStamp) {
            if (newSup != this.sup) {
                this.sup = newSup;
                this.supStamp = supStamp;
            }
        }

        public void setSup(int newSup) {
            if (newSup != this.sup) {
                if (this.supStamp <= this.tree.getEnvironment().getWorldIndex()) {
                    this.tree.getTrail().stack(this.tree, this, 1);
                    this.supStamp = this.tree.getEnvironment().getWorldIndex();
                }
                this.sup = newSup;
            }
        }

        public int getInf() {
            return this.inf;
        }

        public int getSup() {
            return this.sup;
        }

        public String toString() {
            return "[" + this.inf + "," + this.sup + "]";
        }
    }
}

