/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.intutil;

import choco.kernel.common.util.IntIterator;
import choco.kernel.common.util.intutil.AbstractSequentialIntList;
import choco.kernel.common.util.intutil.IntCollection;
import choco.kernel.common.util.intutil.IntDeque;
import choco.kernel.common.util.intutil.IntList;
import choco.kernel.common.util.intutil.IntListIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

@Deprecated
public class LinkedIntList
extends AbstractSequentialIntList
implements IntList,
IntDeque,
Cloneable,
Serializable {
    private transient Entry header = new Entry(Integer.MAX_VALUE, null, null);
    private transient int size = 0;
    private static final long serialVersionUID = 876323262645176354L;

    public LinkedIntList() {
        this.header.next = this.header.previous = this.header;
    }

    public LinkedIntList(IntCollection c) {
        this();
        this.addAll(c);
    }

    @Override
    public int getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.next.element;
    }

    @Override
    public int getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.previous.element;
    }

    @Override
    public int removeFirst() {
        return this.remove(this.header.next);
    }

    @Override
    public int removeLast() {
        return this.remove(this.header.previous);
    }

    @Override
    public void addFirst(int e) {
        this.addBefore(e, this.header.next);
    }

    @Override
    public void addLast(int e) {
        this.addBefore(e, this.header);
    }

    @Override
    public boolean contains(int o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(int e) {
        this.addBefore(e, this.header);
        return true;
    }

    @Override
    public boolean remove(int o) {
        Entry e = this.header.next;
        while (e != this.header) {
            if (o == e.element) {
                this.remove(e);
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public boolean addAll(IntCollection c) {
        return this.addAll(this.size, c);
    }

    @Override
    public boolean addAll(int index, IntCollection c) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int[] a = c.toArray();
        int numNew = a.length;
        if (numNew == 0) {
            return false;
        }
        ++this.modCount;
        Entry successor = index == this.size ? this.header : this.entry(index);
        Entry predecessor = successor.previous;
        for (int i = 0; i < numNew; ++i) {
            Entry e;
            predecessor.next = e = new Entry(a[i], successor, predecessor);
            predecessor = e;
        }
        successor.previous = predecessor;
        this.size += numNew;
        return true;
    }

    @Override
    public void clear() {
        Entry e = this.header.next;
        while (e != this.header) {
            Entry next = e.next;
            e.previous = null;
            e.next = null;
            e.element = Integer.MAX_VALUE;
            e = next;
        }
        this.header.next = this.header.previous = this.header;
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public int get(int index) {
        return this.entry((int)index).element;
    }

    @Override
    public int set(int index, int element) {
        Entry e = this.entry(index);
        int oldVal = e.element;
        e.element = element;
        return oldVal;
    }

    @Override
    public void add(int index, int element) {
        this.addBefore(element, index == this.size ? this.header : this.entry(index));
    }

    @Override
    public int removeAtPosition(int index) {
        return this.remove(this.entry(index));
    }

    private Entry entry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        Entry e = this.header;
        if (index < this.size >> 1) {
            for (int i = 0; i <= index; ++i) {
                e = e.next;
            }
        } else {
            for (int i = this.size; i > index; --i) {
                e = e.previous;
            }
        }
        return e;
    }

    @Override
    public int indexOf(int o) {
        int index = 0;
        Entry e = this.header.next;
        while (e != this.header) {
            if (o == e.element) {
                return index;
            }
            ++index;
            e = e.next;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int o) {
        int index = this.size;
        Entry e = this.header.previous;
        while (e != this.header) {
            --index;
            if (o == e.element) {
                return index;
            }
            e = e.previous;
        }
        return -1;
    }

    @Override
    public int peek() {
        if (this.size == 0) {
            return Integer.MAX_VALUE;
        }
        return this.getFirst();
    }

    @Override
    public int element() {
        return this.getFirst();
    }

    @Override
    public int poll() {
        if (this.size == 0) {
            return Integer.MAX_VALUE;
        }
        return this.removeFirst();
    }

    @Override
    public int remove() {
        return this.removeFirst();
    }

    @Override
    public boolean offer(int e) {
        return this.add(e);
    }

    @Override
    public boolean offerFirst(int e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(int e) {
        this.addLast(e);
        return true;
    }

    @Override
    public int peekFirst() {
        if (this.size == 0) {
            return Integer.MAX_VALUE;
        }
        return this.getFirst();
    }

    @Override
    public int peekLast() {
        if (this.size == 0) {
            return Integer.MAX_VALUE;
        }
        return this.getLast();
    }

    @Override
    public int pollFirst() {
        if (this.size == 0) {
            return Integer.MAX_VALUE;
        }
        return this.removeFirst();
    }

    @Override
    public int pollLast() {
        if (this.size == 0) {
            return Integer.MAX_VALUE;
        }
        return this.removeLast();
    }

    @Override
    public void push(int e) {
        this.addFirst(e);
    }

    @Override
    public int pop() {
        return this.removeFirst();
    }

    @Override
    public boolean removeFirstOccurrence(int o) {
        return this.remove(o);
    }

    @Override
    public boolean removeLastOccurrence(int o) {
        Entry e = this.header.previous;
        while (e != this.header) {
            if (o == e.element) {
                this.remove(e);
                return true;
            }
            e = e.previous;
        }
        return false;
    }

    @Override
    public IntListIterator listIterator(int index) {
        return new IntListItr(index);
    }

    private Entry addBefore(int e, Entry entry) {
        Entry newEntry;
        newEntry.previous.next = newEntry = new Entry(e, entry, entry.previous);
        newEntry.next.previous = newEntry;
        ++this.size;
        ++this.modCount;
        return newEntry;
    }

    private int remove(Entry e) {
        if (e == this.header) {
            throw new NoSuchElementException();
        }
        int result = e.element;
        e.previous.next = e.next;
        e.next.previous = e.previous;
        e.previous = null;
        e.next = null;
        e.element = Integer.MAX_VALUE;
        --this.size;
        ++this.modCount;
        return result;
    }

    @Override
    public IntIterator descendingIterator() {
        return new DescendingIterator();
    }

    public Object clone() throws CloneNotSupportedException {
        LinkedIntList clone;
        try {
            clone = (LinkedIntList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.header.next = clone.header.previous = (clone.header = new Entry(Integer.MAX_VALUE, null, null));
        clone.size = 0;
        clone.modCount = 0;
        Entry e = this.header.next;
        while (e != this.header) {
            clone.add(e.element);
            e = e.next;
        }
        return clone;
    }

    @Override
    public int[] toArray() {
        int[] result = new int[this.size];
        int i = 0;
        Entry e = this.header.next;
        while (e != this.header) {
            result[i++] = e.element;
            e = e.next;
        }
        return result;
    }

    @Override
    public int[] toArray(int[] a) {
        if (a.length < this.size) {
            a = new int[this.size];
        }
        int i = 0;
        int[] result = a;
        Entry e = this.header.next;
        while (e != this.header) {
            result[i++] = e.element;
            e = e.next;
        }
        if (a.length > this.size) {
            a[this.size] = Integer.MAX_VALUE;
        }
        return a;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        Entry e = this.header.next;
        while (e != this.header) {
            s.writeObject(e.element);
            e = e.next;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.header.next = this.header.previous = (this.header = new Entry(Integer.MAX_VALUE, null, null));
        for (int i = 0; i < size; ++i) {
            this.addBefore((Integer)s.readObject(), this.header);
        }
    }

    private class DescendingIterator
    implements IntIterator {
        final IntListItr itr;

        private DescendingIterator() {
            this.itr = new IntListItr(LinkedIntList.this.size());
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasPrevious();
        }

        @Override
        public int next() {
            return this.itr.previous();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    private static class Entry {
        int element;
        Entry next;
        Entry previous;

        Entry(int element, Entry next, Entry previous) {
            this.element = element;
            this.next = next;
            this.previous = previous;
        }
    }

    private class IntListItr
    implements IntListIterator {
        private Entry lastReturned;
        private Entry next;
        private int nextIndex;
        private int expectedModCount;

        IntListItr(int index) {
            this.lastReturned = LinkedIntList.this.header;
            this.expectedModCount = LinkedIntList.this.modCount;
            if (index < 0 || index > LinkedIntList.this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + LinkedIntList.this.size);
            }
            if (index < LinkedIntList.this.size >> 1) {
                this.next = ((LinkedIntList)LinkedIntList.this).header.next;
                this.nextIndex = 0;
                while (this.nextIndex < index) {
                    this.next = this.next.next;
                    ++this.nextIndex;
                }
            } else {
                this.next = LinkedIntList.this.header;
                this.nextIndex = LinkedIntList.this.size;
                while (this.nextIndex > index) {
                    this.next = this.next.previous;
                    --this.nextIndex;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex != LinkedIntList.this.size;
        }

        @Override
        public int next() {
            this.checkForComodification();
            if (this.nextIndex == LinkedIntList.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.element;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex != 0;
        }

        @Override
        public int previous() {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next = this.next.previous;
            --this.nextIndex;
            this.checkForComodification();
            return this.lastReturned.element;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            this.checkForComodification();
            Entry lastNext = this.lastReturned.next;
            try {
                LinkedIntList.this.remove(this.lastReturned);
            }
            catch (NoSuchElementException e) {
                throw new IllegalStateException();
            }
            if (this.next == this.lastReturned) {
                this.next = lastNext;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = LinkedIntList.this.header;
            ++this.expectedModCount;
        }

        @Override
        public void set(int e) {
            if (this.lastReturned == LinkedIntList.this.header) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.element = e;
        }

        @Override
        public void add(int e) {
            this.checkForComodification();
            this.lastReturned = LinkedIntList.this.header;
            LinkedIntList.this.addBefore(e, this.next);
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        final void checkForComodification() {
            if (LinkedIntList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

