/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.intutil;

import choco.kernel.common.util.IntIterator;
import choco.kernel.common.util.intutil.HashIntMap;
import choco.kernel.common.util.intutil.IntMap;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

@Deprecated
public class LinkedHashIntMap<V>
extends HashIntMap<V>
implements IntMap<V> {
    private static final long serialVersionUID = 3801124242820219131L;
    private transient Entry<V> header;
    private final boolean accessOrder;

    public LinkedHashIntMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.accessOrder = false;
    }

    public LinkedHashIntMap(int initialCapacity) {
        super(initialCapacity);
        this.accessOrder = false;
    }

    public LinkedHashIntMap() {
        this.accessOrder = false;
    }

    public LinkedHashIntMap(IntMap<? extends V> m) {
        super(m);
        this.accessOrder = false;
    }

    public LinkedHashIntMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor);
        this.accessOrder = accessOrder;
    }

    @Override
    void init() {
        this.header = new Entry<Object>(-1, Integer.MAX_VALUE, null, null);
        this.header.after = this.header;
        this.header.before = this.header.after;
    }

    @Override
    void transfer(HashIntMap.Entry[] newTable) {
        int newCapacity = newTable.length;
        Entry e = this.header.after;
        while (e != this.header) {
            int index = LinkedHashIntMap.indexFor(e.hash, newCapacity);
            e.next = newTable[index];
            newTable[index] = e;
            e = e.after;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            Entry e = this.header.after;
            while (e != this.header) {
                if (e.value == null) {
                    return true;
                }
                e = e.after;
            }
        } else {
            Entry e = this.header.after;
            while (e != this.header) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.after;
            }
        }
        return false;
    }

    @Override
    public V get(int key) {
        Entry e = (Entry)this.getEntry(key);
        if (e == null) {
            return null;
        }
        e.recordAccess(this);
        return (V)e.value;
    }

    @Override
    public void clear() {
        super.clear();
        this.header.after = this.header;
        this.header.before = this.header.after;
    }

    @Override
    IntIterator newKeyIterator() {
        return new KeyIterator();
    }

    @Override
    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    @Override
    Iterator<IntMap.Entry<V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    void addEntry(int hash, int key, V value, int bucketIndex) {
        this.createEntry(hash, key, value, bucketIndex);
        Entry eldest = this.header.after;
        if (this.removeEldestEntry(eldest)) {
            this.removeEntryForKey(eldest.key);
        } else if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    @Override
    void createEntry(int hash, int key, V value, int bucketIndex) {
        Entry<V> e;
        HashIntMap.Entry old = this.table[bucketIndex];
        this.table[bucketIndex] = e = new Entry<V>(hash, key, value, old);
        ((Entry)e).addBefore((Entry)this.header);
        ++this.size;
    }

    protected boolean removeEldestEntry(IntMap.Entry<V> eldest) {
        return false;
    }

    private class EntryIterator
    extends LinkedHashIterator<IntMap.Entry<V>> {
        private EntryIterator() {
        }

        @Override
        public IntMap.Entry<V> next() {
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends LinkedHashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private class KeyIterator
    extends LinkedHashIntIterator {
        private KeyIterator() {
        }

        @Override
        public int next() {
            return this.nextEntry().getKey();
        }
    }

    private abstract class LinkedHashIntIterator
    implements IntIterator {
        Entry<V> nextEntry;
        Entry<V> lastReturned;
        int expectedModCount;

        private LinkedHashIntIterator() {
            this.nextEntry = ((LinkedHashIntMap)LinkedHashIntMap.this).header.after;
            this.lastReturned = null;
            this.expectedModCount = LinkedHashIntMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != LinkedHashIntMap.this.header;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (LinkedHashIntMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            LinkedHashIntMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
            this.expectedModCount = LinkedHashIntMap.this.modCount;
        }

        Entry<V> nextEntry() {
            if (LinkedHashIntMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextEntry == LinkedHashIntMap.this.header) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            Entry e = this.lastReturned;
            this.nextEntry = e.after;
            return e;
        }
    }

    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        Entry<V> nextEntry;
        Entry<V> lastReturned;
        int expectedModCount;

        private LinkedHashIterator() {
            this.nextEntry = ((LinkedHashIntMap)LinkedHashIntMap.this).header.after;
            this.lastReturned = null;
            this.expectedModCount = LinkedHashIntMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != LinkedHashIntMap.this.header;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (LinkedHashIntMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            LinkedHashIntMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
            this.expectedModCount = LinkedHashIntMap.this.modCount;
        }

        Entry<V> nextEntry() {
            if (LinkedHashIntMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextEntry == LinkedHashIntMap.this.header) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            Entry e = this.lastReturned;
            this.nextEntry = e.after;
            return e;
        }
    }

    private static class Entry<V>
    extends HashIntMap.Entry<V> {
        Entry<V> before;
        Entry<V> after;

        Entry(int hash, int key, V value, HashIntMap.Entry<V> next) {
            super(hash, key, value, next);
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        private void addBefore(Entry<V> existingEntry) {
            this.after = existingEntry;
            this.before = existingEntry.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        void recordAccess(HashIntMap<V> m) {
            LinkedHashIntMap lm = (LinkedHashIntMap)m;
            if (lm.accessOrder) {
                ++lm.modCount;
                this.remove();
                this.addBefore(lm.header);
            }
        }

        @Override
        void recordRemoval(HashIntMap<V> m) {
            this.remove();
        }
    }
}

