/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.intutil;

import choco.kernel.common.util.intutil.AbstractIntList;
import choco.kernel.common.util.intutil.IntCollection;
import choco.kernel.common.util.intutil.IntEnumeration;
import choco.kernel.common.util.intutil.IntList;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

@Deprecated
public class IntVector
extends AbstractIntList
implements IntList,
RandomAccess,
Cloneable,
Serializable {
    protected int[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;

    public IntVector(int initialCapacity, int capacityIncrement) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new int[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public IntVector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public IntVector() {
        this(10);
    }

    public IntVector(IntCollection c) {
        this.elementData = c.toArray();
        this.elementCount = this.elementData.length;
        if (this.elementData.getClass() != int[].class) {
            this.elementData = Arrays.copyOf(this.elementData, this.elementCount);
        }
    }

    public synchronized void copyInto(Object[] anArray) {
        System.arraycopy(this.elementData, 0, anArray, 0, this.elementCount);
    }

    public synchronized void trimToSize() {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            this.elementData = Arrays.copyOf(this.elementData, this.elementCount);
        }
    }

    public synchronized void ensureCapacity(int minCapacity) {
        ++this.modCount;
        this.ensureCapacityHelper(minCapacity);
    }

    private void ensureCapacityHelper(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity;
            int[] oldData = this.elementData;
            int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = Arrays.copyOf(this.elementData, newCapacity);
        }
    }

    public synchronized void setSize(int newSize) {
        ++this.modCount;
        if (newSize > this.elementCount) {
            this.ensureCapacityHelper(newSize);
        }
        this.elementCount = newSize;
    }

    public synchronized int capacity() {
        return this.elementData.length;
    }

    @Override
    public synchronized int size() {
        return this.elementCount;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    public IntEnumeration elements() {
        return new IntEnumeration(){
            int count = 0;

            @Override
            public boolean hasMoreElements() {
                return this.count < IntVector.this.elementCount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int nextElement() {
                IntVector intVector = IntVector.this;
                synchronized (intVector) {
                    if (this.count < IntVector.this.elementCount) {
                        return IntVector.this.elementData[this.count++];
                    }
                }
                throw new NoSuchElementException("IntVector IntEnumeration");
            }
        };
    }

    @Override
    public boolean contains(int o) {
        return this.indexOf(o, 0) >= 0;
    }

    @Override
    public int indexOf(int o) {
        return this.indexOf(o, 0);
    }

    public synchronized int indexOf(int o, int index) {
        for (int i = index; i < this.elementCount; ++i) {
            if (o != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public synchronized int lastIndexOf(int o) {
        return this.lastIndexOf(o, this.elementCount - 1);
    }

    public synchronized int lastIndexOf(int o, int index) {
        if (index >= this.elementCount) {
            throw new IndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        for (int i = index; i >= 0; --i) {
            if (o != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public synchronized int elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        return this.elementData[index];
    }

    public synchronized int firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public synchronized int lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public synchronized void setElementAt(int obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        this.elementData[index] = obj;
    }

    public synchronized void removeElementAt(int index) {
        ++this.modCount;
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
    }

    public synchronized void insertElementAt(int obj, int index) {
        ++this.modCount;
        if (index > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.elementCount);
        }
        this.ensureCapacityHelper(this.elementCount + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public synchronized void addElement(int obj) {
        ++this.modCount;
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = obj;
    }

    public synchronized boolean removeElement(int obj) {
        ++this.modCount;
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public synchronized void removeAllElements() {
        ++this.modCount;
        this.elementCount = 0;
    }

    public synchronized Object clone() {
        try {
            IntVector v = (IntVector)super.clone();
            v.elementData = Arrays.copyOf(this.elementData, this.elementCount);
            v.modCount = 0;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public synchronized int[] toArray() {
        return Arrays.copyOf(this.elementData, this.elementCount);
    }

    @Override
    public synchronized int[] toArray(int[] a) {
        if (a.length < this.elementCount) {
            return Arrays.copyOf(this.elementData, this.elementCount);
        }
        System.arraycopy(this.elementData, 0, a, 0, this.elementCount);
        return a;
    }

    @Override
    public synchronized int get(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.elementData[index];
    }

    @Override
    public synchronized int set(int index, int element) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    @Override
    public synchronized boolean add(int e) {
        ++this.modCount;
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = e;
        return true;
    }

    @Override
    public boolean remove(int o) {
        return this.removeElement(o);
    }

    @Override
    public void add(int index, int element) {
        this.insertElementAt(element, index);
    }

    @Override
    public synchronized int removeAtPosition(int index) {
        ++this.modCount;
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int oldValue = this.elementData[index];
        int numMoved = this.elementCount - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        return oldValue;
    }

    @Override
    public void clear() {
        this.removeAllElements();
    }

    @Override
    public synchronized boolean containsAll(IntCollection c) {
        return super.containsAll(c);
    }

    @Override
    public synchronized boolean addAll(IntCollection c) {
        ++this.modCount;
        int[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacityHelper(this.elementCount + numNew);
        System.arraycopy(a, 0, this.elementData, this.elementCount, numNew);
        this.elementCount += numNew;
        return numNew != 0;
    }

    @Override
    public synchronized boolean removeAll(IntCollection c) {
        return super.removeAll(c);
    }

    @Override
    public synchronized boolean retainAll(IntCollection c) {
        return super.retainAll(c);
    }

    @Override
    public synchronized boolean addAll(int index, IntCollection c) {
        ++this.modCount;
        if (index < 0 || index > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacityHelper(this.elementCount + numNew);
        int numMoved = this.elementCount - index;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index, this.elementData, index + numNew, numMoved);
        }
        System.arraycopy(a, 0, this.elementData, index, numNew);
        this.elementCount += numNew;
        return numNew != 0;
    }

    @Override
    public synchronized boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    @Override
    public synchronized String toString() {
        return super.toString();
    }

    @Override
    protected synchronized void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        int numMoved = this.elementCount - toIndex;
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
        int newElementCount = this.elementCount - (toIndex - fromIndex);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }
}

