/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.intutil;

import choco.kernel.common.util.IntIterator;
import choco.kernel.common.util.intutil.AbstractIntCollection;
import choco.kernel.common.util.intutil.AbstractIntSet;
import choco.kernel.common.util.intutil.IntCollection;
import choco.kernel.common.util.intutil.IntSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

@Deprecated
public class HashIntToIntMap
implements Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static int HASH = 0;
    protected static int KEY = 1;
    protected static int VAL = 2;
    protected static int NIDX = 3;
    transient int[][] table;
    transient ArrayList<int[]> nexts = new ArrayList();
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    private transient Set<int[]> entrySet = null;
    volatile transient IntSet keySet = null;
    volatile transient IntCollection values = null;
    private static final long serialVersionUID = 362498820763181265L;

    public HashIntToIntMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new int[capacity][];
        this.init();
    }

    public HashIntToIntMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashIntToIntMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new int[16][];
        this.init();
    }

    void init() {
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int get(int key) {
        int hash = HashIntToIntMap.hash(key);
        int[] e = this.table[HashIntToIntMap.indexFor(hash, this.table.length)];
        while (e != null) {
            int k;
            if (e[HASH] == hash && ((k = e[KEY]) == key || key == k)) {
                return e[VAL];
            }
            e = this.nexts.get(e[NIDX]);
        }
        return Integer.MAX_VALUE;
    }

    public boolean containsKey(int key) {
        return this.getEntry(key) != null;
    }

    final int[] getEntry(int key) {
        int hash = HashIntToIntMap.hash(key);
        int[] e = this.table[HashIntToIntMap.indexFor(hash, this.table.length)];
        while (e != null) {
            int k;
            if (e[HASH] == hash && ((k = e[KEY]) == key || key == k)) {
                return e;
            }
            e = this.nexts.get(e[NIDX]);
        }
        return null;
    }

    public int put(int key, int value) {
        int hash = HashIntToIntMap.hash(key);
        int i = HashIntToIntMap.indexFor(hash, this.table.length);
        int[] e = this.table[i];
        while (e != null) {
            int k;
            if (e[HASH] == hash && ((k = e[KEY]) == key || key == k)) {
                int oldValue = e[VAL];
                e[HashIntToIntMap.VAL] = value;
                return oldValue;
            }
            e = this.nexts.get(e[NIDX]);
        }
        ++this.modCount;
        this.addEntry(hash, key, value, i);
        return Integer.MAX_VALUE;
    }

    private void putForCreate(int key, int value) {
        int hash = HashIntToIntMap.hash(key);
        int i = HashIntToIntMap.indexFor(hash, this.table.length);
        int[] e = this.table[i];
        while (e != null) {
            int k;
            if (e[HASH] == hash && ((k = e[KEY]) == key || key == k)) {
                e[HashIntToIntMap.VAL] = value;
                return;
            }
            e = this.nexts.get(e[NIDX]);
        }
        this.createEntry(hash, key, value, i);
    }

    private void putAllForCreate(HashIntToIntMap m) {
        for (int[] e : m.entrySet()) {
            this.putForCreate(e[KEY], e[VAL]);
        }
    }

    void resize(int newCapacity) {
        int[][] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int[][] newTable = new int[newCapacity][];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(int[][] newTable) {
        int[][] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            int[] next;
            int[] e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = this.nexts.get(e[NIDX]);
                int i = HashIntToIntMap.indexFor(e[HASH], newCapacity);
                this.nexts.set(e[NIDX], newTable[i]);
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    public void putAll(HashIntToIntMap m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (int[] e : m.entrySet()) {
            this.put(e[KEY], e[VAL]);
        }
    }

    public int remove(int key) {
        int[] e = this.removeEntryForKey(key);
        return e == null ? null : Integer.valueOf(e[VAL]);
    }

    final int[] removeEntryForKey(int key) {
        int[] prev;
        int hash = HashIntToIntMap.hash(key);
        int i = HashIntToIntMap.indexFor(hash, this.table.length);
        int[] e = prev = this.table[i];
        while (e != null) {
            int k;
            int[] next = this.nexts.get(e[NIDX]);
            if (e[HASH] == hash && ((k = e[KEY]) == key || key == k)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    this.nexts.set(prev[NIDX], next);
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    final int[] removeMapping(Object o) {
        int[] prev;
        if (!(o instanceof int[])) {
            return null;
        }
        int[] entry = (int[])o;
        int key = entry[KEY];
        int hash = HashIntToIntMap.hash(key);
        int i = HashIntToIntMap.indexFor(hash, this.table.length);
        int[] e = prev = this.table[i];
        while (e != null) {
            int[] next = this.nexts.get(e[NIDX]);
            if (e[HASH] == hash && Arrays.equals(e, entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    this.nexts.set(prev[NIDX], next);
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    public void clear() {
        ++this.modCount;
        int[][] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    public boolean containsValue(int value) {
        if (value == Integer.MAX_VALUE) {
            return this.containsNullValue();
        }
        int[][] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            int[] e = tab[i];
            while (e != null) {
                if (value == e[VAL]) {
                    return true;
                }
                e = this.nexts.get(e[NIDX]);
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        int[][] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            int[] e = tab[i];
            while (e != null) {
                if (e[VAL] == Integer.MAX_VALUE) {
                    return true;
                }
                e = this.nexts.get(e[NIDX]);
            }
        }
        return false;
    }

    public Object clone() {
        HashIntToIntMap result = null;
        try {
            result = (HashIntToIntMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        result.table = new int[this.table.length][];
        result.entrySet = null;
        result.modCount = 0;
        result.size = 0;
        result.init();
        result.putAllForCreate(this);
        return result;
    }

    void addEntry(int hash, int key, int value, int bucketIndex) {
        int[] e = this.table[bucketIndex];
        this.nexts.add(e);
        this.table[bucketIndex] = new int[]{hash, key, value, this.nexts.size() - 1};
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, int key, int value, int bucketIndex) {
        int[] e = this.table[bucketIndex];
        this.nexts.add(e);
        this.table[bucketIndex] = new int[]{hash, key, value, this.nexts.size() - 1};
        ++this.size;
    }

    IntIterator newKeyIterator() {
        return new KeyIterator();
    }

    IntIterator newValueIterator() {
        return new ValueIterator();
    }

    Iterator<int[]> newEntryIterator() {
        return new EntryIterator();
    }

    public IntSet keySet() {
        IntSet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public IntCollection values() {
        IntCollection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set<int[]> entrySet() {
        return this.entrySet0();
    }

    private Set<int[]> entrySet0() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Iterator<int[]> i = this.size > 0 ? this.entrySet0().iterator() : null;
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        if (i != null) {
            while (i.hasNext()) {
                int[] e = i.next();
                s.writeObject(e[KEY]);
                s.writeObject(e[VAL]);
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new int[numBuckets][];
        this.init();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            int key = (Integer)s.readObject();
            int value = (Integer)s.readObject();
            this.putForCreate(key, value);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    private final class EntrySet
    extends AbstractSet<int[]> {
        private EntrySet() {
        }

        @Override
        public Iterator<int[]> iterator() {
            return HashIntToIntMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof int[])) {
                return false;
            }
            int[] e = (int[])o;
            int[] candidate = HashIntToIntMap.this.getEntry(e[KEY]);
            return candidate != null && Arrays.equals(candidate, e);
        }

        @Override
        public boolean remove(Object o) {
            return HashIntToIntMap.this.removeMapping(o) != null;
        }

        @Override
        public int size() {
            return HashIntToIntMap.this.size;
        }

        @Override
        public void clear() {
            HashIntToIntMap.this.clear();
        }
    }

    private final class Values
    extends AbstractIntCollection {
        private Values() {
        }

        @Override
        public IntIterator iterator() {
            return HashIntToIntMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return HashIntToIntMap.this.size;
        }

        @Override
        public boolean contains(int o) {
            return HashIntToIntMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            HashIntToIntMap.this.clear();
        }
    }

    private final class KeySet
    extends AbstractIntSet {
        private KeySet() {
        }

        @Override
        public IntIterator iterator() {
            return HashIntToIntMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return HashIntToIntMap.this.size;
        }

        @Override
        public boolean contains(int o) {
            return HashIntToIntMap.this.containsKey(o);
        }

        @Override
        public boolean remove(int o) {
            return HashIntToIntMap.this.removeEntryForKey(o) != null;
        }

        @Override
        public void clear() {
            HashIntToIntMap.this.clear();
        }
    }

    private final class EntryIterator
    extends HashIterator<int[]> {
        private EntryIterator() {
        }

        @Override
        public int[] next() {
            return HashIntToIntMap.this.nexts.get(this.nextEntry()[NIDX]);
        }
    }

    private final class KeyIterator
    extends HashIntIterator {
        private KeyIterator() {
        }

        @Override
        public int next() {
            return this.nextEntry()[KEY];
        }
    }

    private final class ValueIterator
    extends HashIntIterator {
        private ValueIterator() {
        }

        @Override
        public int next() {
            return this.nextEntry()[VAL];
        }
    }

    private abstract class HashIntIterator
    implements IntIterator {
        int[] next;
        int expectedModCount;
        int index;
        int[] current;

        HashIntIterator() {
            this.expectedModCount = HashIntToIntMap.this.modCount;
            if (HashIntToIntMap.this.size > 0) {
                int[][] t = HashIntToIntMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final int[] nextEntry() {
            if (HashIntToIntMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            int[] e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = HashIntToIntMap.this.nexts.get(e[NIDX]);
            if (this.next == null) {
                int[][] t = HashIntToIntMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (HashIntToIntMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            int k = this.current[KEY];
            this.current = null;
            HashIntToIntMap.this.removeEntryForKey(k);
            this.expectedModCount = HashIntToIntMap.this.modCount;
        }
    }

    private abstract class HashIterator<V>
    implements Iterator<V> {
        int[] next;
        int expectedModCount;
        int index;
        int[] current;

        HashIterator() {
            this.expectedModCount = HashIntToIntMap.this.modCount;
            if (HashIntToIntMap.this.size > 0) {
                int[][] t = HashIntToIntMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final int[] nextEntry() {
            if (HashIntToIntMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            int[] e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = HashIntToIntMap.this.nexts.get(e[NIDX]);
            if (this.next == null) {
                int[][] t = HashIntToIntMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (HashIntToIntMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            int k = this.current[KEY];
            this.current = null;
            HashIntToIntMap.this.removeEntryForKey(k);
            this.expectedModCount = HashIntToIntMap.this.modCount;
        }
    }
}

