/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.intutil;

import choco.kernel.common.util.IntIterator;
import choco.kernel.common.util.intutil.AbstractIntMap;
import choco.kernel.common.util.intutil.AbstractIntSet;
import choco.kernel.common.util.intutil.IntMap;
import choco.kernel.common.util.intutil.IntSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

@Deprecated
public class HashIntMap<V>
extends AbstractIntMap<V>
implements IntMap<V>,
Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    private transient Set<IntMap.Entry<V>> entrySet = null;
    private static final long serialVersionUID = 362498820763181265L;

    public HashIntMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.init();
    }

    public HashIntMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashIntMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
        this.init();
    }

    public HashIntMap(IntMap<? extends V> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f);
        super.putAllForCreate(m);
    }

    void init() {
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(int key) {
        int hash = HashIntMap.hash(key);
        Entry e = this.table[HashIntMap.indexFor(hash, this.table.length)];
        while (e != null) {
            int k;
            if (e.hash == hash && ((k = e.key) == key || key == k)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(int key) {
        return this.getEntry(key) != null;
    }

    final Entry<V> getEntry(int key) {
        int hash = HashIntMap.hash(key);
        Entry e = this.table[HashIntMap.indexFor(hash, this.table.length)];
        while (e != null) {
            int k;
            if (e.hash == hash && ((k = e.key) == key || key == k)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public V put(int key, V value) {
        int hash = HashIntMap.hash(key);
        int i = HashIntMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            int k;
            if (e.hash == hash && ((k = e.key) == key || key == k)) {
                Object oldValue = e.value;
                e.value = value;
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, key, value, i);
        return null;
    }

    private void putForCreate(int key, V value) {
        int hash = HashIntMap.hash(key);
        int i = HashIntMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            int k;
            if (e.hash == hash && ((k = e.key) == key || key == k)) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(hash, key, value, i);
    }

    private void putAllForCreate(IntMap<? extends V> m) {
        for (IntMap.Entry<V> e : m.entrySet()) {
            this.putForCreate(e.getKey(), e.getValue());
        }
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = HashIntMap.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    @Override
    public void putAll(IntMap<? extends V> m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (IntMap.Entry<V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(int key) {
        Entry<V> e = this.removeEntryForKey(key);
        return e == null ? null : (V)e.value;
    }

    final Entry<V> removeEntryForKey(int key) {
        Entry prev;
        int hash = HashIntMap.hash(key);
        int i = HashIntMap.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            int k;
            Entry next = e.next;
            if (e.hash == hash && ((k = e.key) == key || key == k)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    final Entry<V> removeMapping(Object o) {
        Entry prev;
        if (!(o instanceof IntMap.Entry)) {
            return null;
        }
        IntMap.Entry entry = (IntMap.Entry)o;
        int key = entry.getKey();
        int hash = HashIntMap.hash(key);
        int i = HashIntMap.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public Object clone() {
        HashIntMap result = null;
        try {
            result = (HashIntMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        result.table = new Entry[this.table.length];
        result.entrySet = null;
        result.modCount = 0;
        result.size = 0;
        result.init();
        result.putAllForCreate(this);
        return result;
    }

    void addEntry(int hash, int key, V value, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<V>(hash, key, value, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, int key, V value, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<V>(hash, key, value, e);
        ++this.size;
    }

    IntIterator newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<IntMap.Entry<V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public IntSet keySet() {
        IntSet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<IntMap.Entry<V>> entrySet() {
        return this.entrySet0();
    }

    private Set<IntMap.Entry<V>> entrySet0() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Iterator<IntMap.Entry<V>> i = this.size > 0 ? this.entrySet0().iterator() : null;
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        if (i != null) {
            while (i.hasNext()) {
                IntMap.Entry<V> e = i.next();
                s.writeObject(e.getKey());
                s.writeObject(e.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new Entry[numBuckets];
        this.init();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            int key = (Integer)s.readObject();
            Object value = s.readObject();
            this.putForCreate(key, value);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    private final class EntrySet
    extends AbstractSet<IntMap.Entry<V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<IntMap.Entry<V>> iterator() {
            return HashIntMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            IntMap.Entry e = (IntMap.Entry)o;
            Entry candidate = HashIntMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return HashIntMap.this.removeMapping(o) != null;
        }

        @Override
        public int size() {
            return HashIntMap.this.size;
        }

        @Override
        public void clear() {
            HashIntMap.this.clear();
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return HashIntMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return HashIntMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return HashIntMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            HashIntMap.this.clear();
        }
    }

    private final class KeySet
    extends AbstractIntSet {
        private KeySet() {
        }

        @Override
        public IntIterator iterator() {
            return HashIntMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return HashIntMap.this.size;
        }

        @Override
        public boolean contains(int o) {
            return HashIntMap.this.containsKey(o);
        }

        @Override
        public boolean remove(int o) {
            return HashIntMap.this.removeEntryForKey(o) != null;
        }

        @Override
        public void clear() {
            HashIntMap.this.clear();
        }
    }

    private final class EntryIterator
    extends HashIterator<IntMap.Entry<V>> {
        private EntryIterator() {
        }

        @Override
        public IntMap.Entry<V> next() {
            return this.nextEntry();
        }
    }

    private final class KeyIterator
    extends HashIntIterator {
        private KeyIterator() {
        }

        @Override
        public int next() {
            return this.nextEntry().getKey();
        }
    }

    private final class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIntIterator
    implements IntIterator {
        Entry<V> next;
        int expectedModCount;
        int index;
        Entry<V> current;

        HashIntIterator() {
            this.expectedModCount = HashIntMap.this.modCount;
            if (HashIntMap.this.size > 0) {
                Entry[] t = HashIntMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<V> nextEntry() {
            if (HashIntMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.next;
            if (this.next == null) {
                Entry[] t = HashIntMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (HashIntMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            int k = this.current.key;
            this.current = null;
            HashIntMap.this.removeEntryForKey(k);
            this.expectedModCount = HashIntMap.this.modCount;
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry<V> next;
        int expectedModCount;
        int index;
        Entry<V> current;

        HashIterator() {
            this.expectedModCount = HashIntMap.this.modCount;
            if (HashIntMap.this.size > 0) {
                Entry[] t = HashIntMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<V> nextEntry() {
            if (HashIntMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.next;
            if (this.next == null) {
                Entry[] t = HashIntMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (HashIntMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            int k = this.current.key;
            this.current = null;
            HashIntMap.this.removeEntryForKey(k);
            this.expectedModCount = HashIntMap.this.modCount;
        }
    }

    static class Entry<V>
    implements IntMap.Entry<V> {
        final int key;
        V value;
        Entry<V> next;
        final int hash;

        Entry(int h, int k, V v, Entry<V> n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        @Override
        public final int getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Object v2;
            V v1;
            Integer k2;
            if (!(o instanceof IntMap.Entry)) {
                return false;
            }
            IntMap.Entry e = (IntMap.Entry)o;
            Integer k1 = this.getKey();
            return (k1 == (k2 = Integer.valueOf(e.getKey())) || k1 != null && ((Object)k1).equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final int hashCode() {
            return this.key ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(HashIntMap<V> m) {
        }

        void recordRemoval(HashIntMap<V> m) {
        }
    }
}

