/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.intutil;

import choco.kernel.common.util.IntIterator;
import choco.kernel.common.util.intutil.AbstractIntCollection;
import choco.kernel.common.util.intutil.IntCollection;
import choco.kernel.common.util.intutil.IntDeque;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

@Deprecated
public class ArrayIntDeque
extends AbstractIntCollection
implements IntDeque,
Cloneable,
Serializable {
    private transient int[] elements;
    private transient int head;
    private transient int tail;
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final long serialVersionUID = 2340985798034038923L;

    private void allocateElements(int numElements) {
        int initialCapacity = 8;
        if (numElements >= initialCapacity) {
            initialCapacity = numElements;
            initialCapacity |= initialCapacity >>> 1;
            initialCapacity |= initialCapacity >>> 2;
            initialCapacity |= initialCapacity >>> 4;
            initialCapacity |= initialCapacity >>> 8;
            initialCapacity |= initialCapacity >>> 16;
            if (++initialCapacity < 0) {
                initialCapacity >>>= 1;
            }
        }
        this.elements = new int[initialCapacity];
        Arrays.fill(this.elements, Integer.MAX_VALUE);
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int p = this.head;
        int n = this.elements.length;
        int r = n - p;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Sorry, deque too big");
        }
        int[] a = new int[newCapacity];
        Arrays.fill(a, Integer.MAX_VALUE);
        System.arraycopy(this.elements, p, a, 0, r);
        System.arraycopy(this.elements, 0, a, r, p);
        this.elements = a;
        this.head = 0;
        this.tail = n;
    }

    private int[] copyElements(int[] a) {
        if (this.head < this.tail) {
            System.arraycopy(this.elements, this.head, a, 0, this.size());
        } else if (this.head > this.tail) {
            int headPortionLen = this.elements.length - this.head;
            System.arraycopy(this.elements, this.head, a, 0, headPortionLen);
            System.arraycopy(this.elements, 0, a, headPortionLen, this.tail);
        }
        return a;
    }

    public ArrayIntDeque() {
        this.elements = new int[16];
        Arrays.fill(this.elements, Integer.MAX_VALUE);
    }

    public ArrayIntDeque(int numElements) {
        this.allocateElements(numElements);
    }

    public ArrayIntDeque(IntCollection c) {
        this.allocateElements(c.size());
        this.addAll(c);
    }

    @Override
    public void addFirst(int e) {
        this.head = this.head - 1 & this.elements.length - 1;
        this.elements[this.head] = e;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    @Override
    public void addLast(int e) {
        this.elements[this.tail] = e;
        this.tail = this.tail + 1 & this.elements.length - 1;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
    }

    @Override
    public boolean offerFirst(int e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(int e) {
        this.addLast(e);
        return true;
    }

    @Override
    public int removeFirst() {
        int x = this.pollFirst();
        if (x == Integer.MAX_VALUE) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public int removeLast() {
        int x = this.pollLast();
        if (x == Integer.MAX_VALUE) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public int pollFirst() {
        int h = this.head;
        int result = this.elements[h];
        if (result == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        this.elements[h] = Integer.MAX_VALUE;
        this.head = h + 1 & this.elements.length - 1;
        return result;
    }

    @Override
    public int pollLast() {
        int t = this.tail - 1 & this.elements.length - 1;
        int result = this.elements[t];
        if (result == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        this.elements[t] = Integer.MAX_VALUE;
        this.tail = t;
        return result;
    }

    @Override
    public int getFirst() {
        int x = this.elements[this.head];
        if (x == Integer.MAX_VALUE) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public int getLast() {
        int x = this.elements[this.tail - 1 & this.elements.length - 1];
        if (x == Integer.MAX_VALUE) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public int peekFirst() {
        return this.elements[this.head];
    }

    @Override
    public int peekLast() {
        return this.elements[this.tail - 1 & this.elements.length - 1];
    }

    @Override
    public boolean removeFirstOccurrence(int o) {
        int x;
        if (o == Integer.MAX_VALUE) {
            return false;
        }
        int mask = this.elements.length - 1;
        int i = this.head;
        while ((x = this.elements[i]) != Integer.MAX_VALUE) {
            if (o == x) {
                this.delete(i);
                return true;
            }
            i = i + 1 & mask;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(int o) {
        int x;
        if (o == Integer.MAX_VALUE) {
            return false;
        }
        int mask = this.elements.length - 1;
        int i = this.tail - 1 & mask;
        while ((x = this.elements[i]) != Integer.MAX_VALUE) {
            if (o == x) {
                this.delete(i);
                return true;
            }
            i = i - 1 & mask;
        }
        return false;
    }

    @Override
    public boolean add(int e) {
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(int e) {
        return this.offerLast(e);
    }

    @Override
    public int remove() {
        return this.removeFirst();
    }

    @Override
    public int poll() {
        return this.pollFirst();
    }

    @Override
    public int element() {
        return this.getFirst();
    }

    @Override
    public int peek() {
        return this.peekFirst();
    }

    @Override
    public void push(int e) {
        this.addFirst(e);
    }

    @Override
    public int pop() {
        return this.removeFirst();
    }

    private void checkInvariants() {
        assert (this.elements[this.tail] == Integer.MAX_VALUE);
        assert (this.head != this.tail ? this.elements[this.head] != Integer.MAX_VALUE && this.elements[this.tail - 1 & this.elements.length - 1] != Integer.MAX_VALUE : this.elements[this.head] == Integer.MAX_VALUE);
        assert (this.elements[this.head - 1 & this.elements.length - 1] == Integer.MAX_VALUE);
    }

    private boolean delete(int i) {
        this.checkInvariants();
        int[] elements = this.elements;
        int mask = elements.length - 1;
        int h = this.head;
        int t = this.tail;
        int front = i - h & mask;
        int back = t - i & mask;
        if (front >= (t - h & mask)) {
            throw new ConcurrentModificationException();
        }
        if (front < back) {
            if (h <= i) {
                System.arraycopy(elements, h, elements, h + 1, front);
            } else {
                System.arraycopy(elements, 0, elements, 1, i);
                elements[0] = elements[mask];
                System.arraycopy(elements, h, elements, h + 1, mask - h);
            }
            elements[h] = Integer.MAX_VALUE;
            this.head = h + 1 & mask;
            return false;
        }
        if (i < t) {
            System.arraycopy(elements, i + 1, elements, i, back);
            this.tail = t - 1;
        } else {
            System.arraycopy(elements, i + 1, elements, i, mask - i);
            elements[mask] = elements[0];
            System.arraycopy(elements, 1, elements, 0, t);
            this.tail = t - 1 & mask;
        }
        return true;
    }

    @Override
    public int size() {
        return this.tail - this.head & this.elements.length - 1;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public IntIterator iterator() {
        return new DeqIterator();
    }

    @Override
    public IntIterator descendingIterator() {
        return new DescendingIterator();
    }

    @Override
    public boolean contains(int o) {
        int x;
        if (o == Integer.MAX_VALUE) {
            return false;
        }
        int mask = this.elements.length - 1;
        int i = this.head;
        while ((x = this.elements[i]) != Integer.MAX_VALUE) {
            if (o == x) {
                return true;
            }
            i = i + 1 & mask;
        }
        return false;
    }

    @Override
    public boolean remove(int o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public void clear() {
        int h = this.head;
        int t = this.tail;
        if (h != t) {
            this.tail = 0;
            this.head = 0;
            int i = h;
            int mask = this.elements.length - 1;
            do {
                this.elements[i] = Integer.MAX_VALUE;
            } while ((i = i + 1 & mask) != t);
        }
    }

    @Override
    public int[] toArray() {
        return this.copyElements(new int[this.size()]);
    }

    @Override
    public int[] toArray(int[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new int[size];
        }
        this.copyElements(a);
        if (a.length > size) {
            a[size] = Integer.MAX_VALUE;
        }
        return a;
    }

    public ArrayIntDeque clone() {
        try {
            ArrayIntDeque result = (ArrayIntDeque)super.clone();
            result.elements = Arrays.copyOf(this.elements, this.elements.length);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size());
        int mask = this.elements.length - 1;
        int i = this.head;
        while (i != this.tail) {
            s.writeObject(this.elements[i]);
            i = i + 1 & mask;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.allocateElements(size);
        this.head = 0;
        this.tail = size;
        for (int i = 0; i < size; ++i) {
            this.elements[i] = (Integer)s.readObject();
        }
    }

    private class DescendingIterator
    implements IntIterator {
        private int cursor;
        private int fence;
        private int lastRet;

        private DescendingIterator() {
            this.cursor = ArrayIntDeque.this.tail;
            this.fence = ArrayIntDeque.this.head;
            this.lastRet = -1;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.fence;
        }

        @Override
        public int next() {
            if (this.cursor == this.fence) {
                throw new NoSuchElementException();
            }
            this.cursor = this.cursor - 1 & ArrayIntDeque.this.elements.length - 1;
            int result = ArrayIntDeque.this.elements[this.cursor];
            if (ArrayIntDeque.this.head != this.fence || result == Integer.MAX_VALUE) {
                throw new ConcurrentModificationException();
            }
            this.lastRet = this.cursor;
            return result;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            if (!ArrayIntDeque.this.delete(this.lastRet)) {
                this.cursor = this.cursor + 1 & ArrayIntDeque.this.elements.length - 1;
                this.fence = ArrayIntDeque.this.head;
            }
            this.lastRet = -1;
        }
    }

    private class DeqIterator
    implements IntIterator {
        private int cursor;
        private int fence;
        private int lastRet;

        private DeqIterator() {
            this.cursor = ArrayIntDeque.this.head;
            this.fence = ArrayIntDeque.this.tail;
            this.lastRet = -1;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.fence;
        }

        @Override
        public int next() {
            if (this.cursor == this.fence) {
                throw new NoSuchElementException();
            }
            int result = ArrayIntDeque.this.elements[this.cursor];
            if (ArrayIntDeque.this.tail != this.fence || result == Integer.MAX_VALUE) {
                throw new ConcurrentModificationException();
            }
            this.lastRet = this.cursor;
            this.cursor = this.cursor + 1 & ArrayIntDeque.this.elements.length - 1;
            return result;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            if (ArrayIntDeque.this.delete(this.lastRet)) {
                this.cursor = this.cursor - 1 & ArrayIntDeque.this.elements.length - 1;
                this.fence = ArrayIntDeque.this.tail;
            }
            this.lastRet = -1;
        }
    }
}

