/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.intutil;

import choco.kernel.common.util.IntIterator;
import choco.kernel.common.util.intutil.AbstractIntCollection;
import choco.kernel.common.util.intutil.IntCollection;
import choco.kernel.common.util.intutil.IntList;
import choco.kernel.common.util.intutil.IntListIterator;
import choco.kernel.common.util.intutil.RandomAccessSubIntList;
import choco.kernel.common.util.intutil.SubIntList;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

@Deprecated
public abstract class AbstractIntList
extends AbstractIntCollection
implements IntList {
    protected transient int modCount = 0;

    protected AbstractIntList() {
    }

    @Override
    public boolean add(int e) {
        this.add(this.size(), e);
        return true;
    }

    @Override
    public abstract int get(int var1);

    @Override
    public int set(int index, int element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, int element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int removeAtPosition(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(int o) {
        IntListIterator e = this.listIterator();
        while (e.hasNext()) {
            if (o != e.next()) continue;
            return e.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int o) {
        IntListIterator e = this.listIterator(this.size());
        while (e.hasPrevious()) {
            if (o != e.previous()) continue;
            return e.nextIndex();
        }
        return -1;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean addAll(int index, IntCollection c) {
        boolean modified = false;
        IntIterator e = c.iterator();
        while (e.hasNext()) {
            this.add(index++, e.next());
            modified = true;
        }
        return modified;
    }

    @Override
    public IntIterator iterator() {
        return new Itr();
    }

    @Override
    public IntListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public IntListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new IntListItr(index);
    }

    @Override
    public IntList subList(int fromIndex, int toIndex) {
        return this instanceof RandomAccess ? new RandomAccessSubIntList(this, fromIndex, toIndex) : new SubIntList(this, fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntList)) {
            return false;
        }
        IntListIterator e1 = this.listIterator();
        IntListIterator e2 = ((IntList)o).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            int o2;
            int o1 = e1.next();
            if (o1 == (o2 = e2.next())) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        IntIterator i = this.iterator();
        while (i.hasNext()) {
            int obj = i.next();
            hashCode = 31 * hashCode + obj;
        }
        return hashCode;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        IntListIterator it = this.listIterator(fromIndex);
        int n = toIndex - fromIndex;
        for (int i = 0; i < n; ++i) {
            it.next();
            it.remove();
        }
    }

    private class IntListItr
    extends Itr
    implements IntListIterator {
        IntListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int previous() {
            this.checkForComodification();
            try {
                int i = this.cursor - 1;
                int previous = AbstractIntList.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(int e) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractIntList.this.set(this.lastRet, e);
                this.expectedModCount = AbstractIntList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(int e) {
            this.checkForComodification();
            try {
                AbstractIntList.this.add(this.cursor++, e);
                this.lastRet = -1;
                this.expectedModCount = AbstractIntList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements IntIterator {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = AbstractIntList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != AbstractIntList.this.size();
        }

        @Override
        public int next() {
            this.checkForComodification();
            try {
                int next = AbstractIntList.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractIntList.this.removeAtPosition(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = AbstractIntList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (AbstractIntList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

