/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util;

import choco.kernel.model.constraints.automaton.FA.Automaton;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class UtilAlgo {
    public static void quicksort(int[] a, IntDomainVar[] vs, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = UtilAlgo.partition(a, vs, left, right);
        UtilAlgo.quicksort(a, vs, left, i - 1);
        UtilAlgo.quicksort(a, vs, i + 1, right);
    }

    private static int partition(int[] a, IntDomainVar[] vs, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            UtilAlgo.exch(a, vs, i, j);
        }
        UtilAlgo.exch(a, vs, i, right);
        return i;
    }

    private static void exch(int[] a, IntDomainVar[] vs, int i, int j) {
        int swap = a[i];
        IntDomainVar vswap = vs[i];
        a[i] = a[j];
        vs[i] = vs[j];
        a[j] = swap;
        vs[j] = vswap;
    }

    public static <T> T[] appendAndCast(Class c, T[] ... toAppend) {
        int total = 0;
        for (T[] tab : toAppend) {
            if (tab == null) continue;
            total += tab.length;
        }
        Object[] ret = (Object[])Array.newInstance(c, total);
        int pos = 0;
        for (T[] tab : toAppend) {
            if (tab == null) continue;
            System.arraycopy(tab, 0, ret, pos, tab.length);
            pos += tab.length;
        }
        return ret;
    }

    public static <T> T[] append(T[] ... toAppend) {
        int total = 0;
        for (T[] tab : toAppend) {
            total += tab.length;
        }
        Object[] ret = (Object[])Array.newInstance(toAppend[0].getClass().getComponentType(), total);
        int pos = 0;
        for (T[] tab : toAppend) {
            System.arraycopy(tab, 0, ret, pos, tab.length);
            pos += tab.length;
        }
        return ret;
    }

    public static void reverse(int[] tab, IntDomainVar[] vs) {
        int i;
        int[] revtab = new int[tab.length];
        IntDomainVar[] revvs = new IntDomainVar[vs.length];
        for (i = 0; i < revtab.length; ++i) {
            revtab[i] = tab[revtab.length - 1 - i];
            revvs[i] = vs[revtab.length - 1 - i];
        }
        for (i = 0; i < revtab.length; ++i) {
            tab[i] = revtab[i];
            vs[i] = revvs[i];
        }
    }

    public static void inverseSign(int[] tab) {
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = -tab[i];
        }
    }

    public static void reverse(int[] tab) {
        int n = tab.length;
        for (int i = 0; i < n / 2; ++i) {
            int tmp = tab[i];
            tab[i] = tab[n - i - 1];
            tab[n - i - 1] = tmp;
        }
    }

    public static <T> void reverse(T[] tab) {
        int n = tab.length;
        for (int i = 0; i < n / 2; ++i) {
            T tmp = tab[i];
            tab[i] = tab[n - i];
            tab[n - i] = tmp;
        }
    }

    public static <T> void permutation(int[] permutation, T[] tab) {
        Object[] tmp = (Object[])Array.newInstance(tab[0].getClass(), tab.length);
        System.arraycopy(tab, 0, tmp, 0, tab.length);
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = tmp[permutation[i]];
        }
    }

    public static <T> ArrayList<T> toList(T[] array) {
        if (array.length > 0) {
            ArrayList<T> list = new ArrayList<T>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list.add(i, array[i]);
            }
            return list;
        }
        return null;
    }

    public static <T> T[] toArray(Class c, ArrayList<T> list) {
        if (list.size() > 0) {
            Object[] array = (Object[])Array.newInstance(c, list.size());
            return list.toArray(array);
        }
        return null;
    }

    public static <T> T[] toArray(ArrayList<T> list) {
        return UtilAlgo.toArray(list.get(0).getClass(), list);
    }

    public static <T> T[][] transpose(T[][] matrix) {
        int i;
        Object[][] ret = (Object[][])Array.newInstance(matrix.getClass().getComponentType(), matrix[0].length);
        for (i = 0; i < ret.length; ++i) {
            ret[i] = (Object[])Array.newInstance(matrix[0].getClass().getComponentType(), matrix.length);
        }
        for (i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                ret[j][i] = matrix[i][j];
            }
        }
        return ret;
    }

    public static <T> T[] flatten(T[][] matrix) {
        int sz = 0;
        for (T[] t : matrix) {
            sz += t.length;
        }
        Object[] ret = (Object[])Array.newInstance(matrix[0].getClass().getComponentType(), sz);
        int k = 0;
        T[][] arr$ = matrix;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            T[] ta;
            for (T t : ta = arr$[i$]) {
                ret[k++] = t;
            }
        }
        return ret;
    }

    public static String toCharExp(String strRegExp) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < strRegExp.length(); ++i) {
            char c = strRegExp.charAt(i);
            if (c == '<') {
                int out = strRegExp.indexOf(62, i + 1);
                int tmp = Integer.parseInt(strRegExp.substring(i + 1, out));
                b.append((char)Automaton.getCharFromInt(tmp));
                i = out;
                continue;
            }
            if (Character.isDigit(c)) {
                b.append((char)Automaton.getCharFromInt(Character.getNumericValue(c)));
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String toIntExp(String charExp) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < charExp.length(); ++i) {
            int c = charExp.charAt(i);
            if (c == 40 || c == 41 || c == 42 || c == 43 || c == 124) {
                b.append((char)c);
                continue;
            }
            int n = c;
            if (n >= 35) {
                --n;
            }
            if (n < 10) {
                b.append(n);
                continue;
            }
            b.append('<').append(n).append('>');
        }
        return b.toString();
    }
}

