/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util;

import choco.kernel.common.util.IntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateIntVector;
import java.util.logging.Logger;

public class StoredPointerCycle {
    public static final int INVALID_INDEX = -1;
    protected IStateIntVector next;
    protected static Logger logger = Logger.getLogger("choco");

    public StoredPointerCycle(IEnvironment env) {
        this.next = env.makeIntVector();
    }

    public int size() {
        return this.next.size();
    }

    public boolean isInCycle(int idx) {
        int n = this.next.size();
        int k = idx == 0 ? n - 1 : idx - 1;
        return n != 0 && this.next.get(k) == idx;
    }

    public void add(int idx, boolean inCycle) {
        if (idx >= 1) {
            int j = this.next.get(idx - 1);
            int k = idx - 1;
            if (j == -1 && inCycle) {
                this.next.add(idx);
            } else {
                this.next.add(j);
            }
            if (inCycle) {
                while (k >= 0 && k >= j && this.next.get(k) == j) {
                    this.next.set(k, idx);
                    --k;
                }
            }
        } else if (inCycle) {
            this.next.add(0);
        } else {
            this.next.add(-1);
        }
    }

    public void setInCycle(int i) {
        int n = this.next.size();
        int nextIdx = this.next.get(i);
        if (nextIdx == -1) {
            for (int j = 0; j < n; ++j) {
                this.next.set(j, i);
            }
        } else {
            int k = i == 0 ? n - 1 : i - 1;
            boolean needToContinue = true;
            while (needToContinue) {
                if (this.next.get(k) == nextIdx) {
                    this.next.set(k, i);
                    needToContinue = k != nextIdx;
                } else {
                    needToContinue = false;
                }
                k = k == 0 ? n - 1 : k - 1;
            }
        }
    }

    public void setOutOfCycle(int i) {
        block4: {
            int n = this.next.size();
            if (this.next.get(i) == -1) break block4;
            if (this.next.get(i) == i) {
                for (int j = 0; j < n; ++j) {
                    this.next.set(j, -1);
                }
            } else {
                int k;
                int j = this.next.get(i);
                int n2 = k = i == 0 ? n - 1 : i - 1;
                while (this.next.get(k) == i) {
                    this.next.set(k, j);
                    k = k == 0 ? n - 1 : k - 1;
                }
            }
        }
    }

    public IntIterator getCycleButIterator(int avoidIndex) {
        int n = this.size();
        if (avoidIndex != -1) {
            --n;
        }
        if (n > 0) {
            return new CyclicIterator(this, avoidIndex);
        }
        return new EmptyIterator();
    }

    class CyclicIterator
    implements IntIterator {
        private IStateIntVector itnext;
        private int k;
        private int endMarker;
        private boolean didCircleArnoundTheEnd;

        public CyclicIterator(StoredPointerCycle pCycle, int avoidIndex) {
            this.itnext = pCycle.next;
            this.didCircleArnoundTheEnd = false;
            int n = pCycle.size();
            if (n > 0) {
                if (avoidIndex == -1) {
                    this.k = n - 1;
                    this.endMarker = n;
                } else {
                    this.k = avoidIndex;
                    this.endMarker = avoidIndex;
                }
            } else {
                this.k = -1;
                this.endMarker = -1;
            }
        }

        @Override
        public boolean hasNext() {
            int nextk = this.itnext.get(this.k);
            if (!this.didCircleArnoundTheEnd) {
                return nextk > this.k || nextk > -1 && nextk < this.endMarker;
            }
            return nextk > this.k && nextk < this.endMarker;
        }

        @Override
        public int next() {
            int prevk = this.k;
            this.k = this.itnext.get(this.k);
            if (!this.didCircleArnoundTheEnd && this.k <= prevk) {
                prevk = -1;
                this.didCircleArnoundTheEnd = true;
            }
            return this.k;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class EmptyIterator
    implements IntIterator {
        EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int next() {
            return 0;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

