/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util;

import choco.kernel.common.util.IPermutation;
import choco.kernel.common.util.Identity;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

class SortingPermutation
implements IPermutation,
Comparator<Integer> {
    public static final IPermutation IDENTITY = Identity.SINGLETON;
    protected boolean identity;
    protected final int[] elements;
    protected final Integer[] orderingPermutation;
    protected final Integer[] reversePermutation;

    public SortingPermutation(int[] elements, boolean reverse) {
        this.elements = elements;
        this.orderingPermutation = new Integer[elements.length];
        this.reversePermutation = new Integer[elements.length];
        for (int i = 0; i < this.orderingPermutation.length; ++i) {
            this.orderingPermutation[i] = i;
        }
        this.sort(reverse);
    }

    public final void sort(boolean reverse) {
        Arrays.sort(this.orderingPermutation, reverse ? Collections.reverseOrder(this) : this);
        this.identity = true;
        for (int i = 0; i < this.orderingPermutation.length; ++i) {
            this.reversePermutation[this.orderingPermutation[i].intValue()] = i;
            if (!this.identity || i == this.orderingPermutation[i]) continue;
            this.identity = false;
        }
    }

    @Override
    public final <T> void applyPermutation(T[] source, T[] dest) {
        if (source.length != this.orderingPermutation.length || source.length != dest.length) {
            throw new ArrayIndexOutOfBoundsException("the two arguments should have the same length than the permutation array");
        }
        for (int i = 0; i < source.length; ++i) {
            dest[i] = source[this.orderingPermutation[i]];
        }
    }

    @Override
    public int[] applyPermutation(int[] source) {
        int[] dest = new int[this.elements.length];
        for (int i = 0; i < this.elements.length; ++i) {
            dest[i] = source[this.orderingPermutation[i]];
        }
        return dest;
    }

    public final int[] applyPermutation() {
        return this.applyPermutation(this.elements);
    }

    @Override
    public final int getOriginalIndex(int idx) {
        return this.orderingPermutation[idx];
    }

    @Override
    public final int getPermutationIndex(int idx) {
        return this.reversePermutation[idx];
    }

    @Override
    public int compare(Integer o1, Integer o2) {
        if (this.elements[o1] > this.elements[o2]) {
            return 1;
        }
        if (this.elements[o1] < this.elements[o2]) {
            return -1;
        }
        return 0;
    }

    @Override
    public final boolean isIdentity() {
        return this.identity;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Criteria: ");
        b.append(Arrays.toString(this.elements));
        b.append("\nOrdering permutation: ");
        b.append(Arrays.toString((Object[])this.orderingPermutation));
        b.append('\n');
        return new String(b);
    }
}

